/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.esdatasourceplugin;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Config;
import android.util.Log;

public class EventStreamListener extends BroadcastReceiver {

    protected static final String LOG_TAG = "TS Datasource plugin";

    @Override
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if(Config.DEBUG) {
            Log.d(LOG_TAG, "Got broadcast " + action);
        }
        if(action != null) {
            if (EventStreamContentProvider.Intents.VIEW_EVENT_INTENT.equals(action)) {
                intent.setClassName("com.sonyericsson.esdatasourceplugin",
                        "com.sonyericsson.esdatasourceplugin.ViewEventActivity");
                intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                context.startActivity(intent);
            }
        }
    }
}
