/*
 *  The MIT License
 *
 *  Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package com.example.hello.android.ui_pattern_listview_crud_db;

import com.example.hello.android.ui_pattern_listview_crud_db.db.UserDBConstants;

/**
 *
 * @author sawai
 */
public interface UserListConstants
{
	String EXTRA_ID = UserListConstants.class.getPackage().getName() + ".EXTRA_ID";
	int REQUEST_CODE_VIEW_USER = 101;
	int REQUEST_CODE_EDIT_USER = 102;
	int REQUEST_CODE_ADD_USER = 103;
	int REQUEST_CODE_DELETE_USER = 104;
	String[] MAPPING_FROM =
	{
		UserDBConstants.Columns.FIRST_NAME,
		UserDBConstants.Columns.LAST_NAME,
		UserDBConstants.Columns.EMAIL,
		UserDBConstants.Columns.AGE,
	};
	int[] MAPPING_TO =
	{
		R.id.first_name_textview,
		R.id.last_name_textview,
		R.id.email_textview,
		R.id.age_textview,
	};
}
