/*
 * The MIT License
 *
 * Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.service_hello;

import android.app.Service;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.util.Log;
import android.widget.Toast;

/**
 *
 * @author sawai
 */
public class CountDownService extends Service
	implements Runnable
{

	private static final String LOG_TAG = "XXX";
	private static final long COUNT_INTERVAL_MSEC = 10000; // 10 sec
	private static final int COUNT = 10;
	private Handler handler;
	private boolean running;
	private int count;

	@Override
	public void onCreate()
	{
		Log.v(LOG_TAG, "onCreate() : Hello");
		super.onCreate();
		handler = new Handler();
		running = false;
		Log.v(LOG_TAG, "onCreate() : Bye");
	}

	@Override
	public void onDestroy()
	{
		Log.v(LOG_TAG, "onDestroy() : Hello");
		running = false;
		super.onDestroy();
		Log.v(LOG_TAG, "onDestroy() : Bye");
	}

	@Override
	public void onStart(Intent intent, int startId)
	{
		Log.v(LOG_TAG, "onStart() : Hello");
		super.onStart(intent, startId);
		if (!running)
		{
			running = true;
			count = COUNT;
			handler.postDelayed(this, COUNT_INTERVAL_MSEC);
		}
		Log.v(LOG_TAG, "onStart() : Bye");
	}

	@Override
	public IBinder onBind(Intent intent)
	{
		Log.v(LOG_TAG, "onBind() : Hello");
		Log.v(LOG_TAG, "onBind() : Bye");
		return null;
	}

	@Override
	public void run()
	{
		Log.v(LOG_TAG, "run() : Hello");
		if (running)
		{
			Log.i(LOG_TAG, "run() count : " + count);
			Toast.makeText(this, "count : " + count, Toast.LENGTH_SHORT).show();
			count--;
			if (count <= 0)
			{
				stopSelf();
			}
			else
			{
				handler.postDelayed(this, COUNT_INTERVAL_MSEC);
			}
		}
		Log.v(LOG_TAG, "run() : Bye");
	}
}
