/*
 * The MIT License
 *
 * Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.listview_simple_adapter;

import android.app.ListActivity;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.SimpleAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MainActivity extends ListActivity
	implements OnClickListener
{

	private SimpleAdapter userListAdapter;
	private List<Map<String, String>> userList;
	private static final String MAP_KEY_FIRST_NAME = "firstName";
	private static final String MAP_KEY_LAST_NAME = "lastName";
	private static final String MAP_KEY_EMAIL = "email";
	private static final String[] MAPPING_FROM = new String[]
	{
		MAP_KEY_FIRST_NAME, MAP_KEY_LAST_NAME, MAP_KEY_EMAIL
	};
	private static final int[] MAPPING_TO = new int[]
	{
		R.id.first_name_textview,
		R.id.last_name_textview,
		R.id.email_textview
	};

	@Override
	public void onClick(View view)
	{
		switch (view.getId())
		{
			case R.id.add_button:
				addUserInfo();
				break;
		}
	}

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main_activity);

		// Init ArrayAdapter
		userListAdapter = new SimpleAdapter(this, getUserList(),
			R.layout.user_list_item, MAPPING_FROM, MAPPING_TO);
		setListAdapter(userListAdapter);

		Button addButton = (Button) findViewById(R.id.add_button);
		addButton.setOnClickListener(this);
	}

	private void addUserInfo()
	{
		List<Map<String, String>> list = getUserList();
		list.add(new HashMap<String, String>()
		{
			
			{
				put(MAP_KEY_FIRST_NAME, "Hoge");
				put(MAP_KEY_LAST_NAME, "Fuga");
				put(MAP_KEY_EMAIL, "hoge.fuga@example.com");
			}
		});
		userListAdapter.notifyDataSetChanged();
	}

	private List<Map<String, String>> getUserList()
	{
		if (userList == null)
		{
			userList = new ArrayList<Map<String, String>>();
			String[] names = getResources().getStringArray(R.array.names);
			for (String name : names)
			{
				HashMap<String, String> userInfo = new HashMap<String, String>();
				userInfo.put(MAP_KEY_FIRST_NAME, name);
				userInfo.put(MAP_KEY_LAST_NAME, "Smith");
				userInfo.put(MAP_KEY_EMAIL, name.toLowerCase() + "@example.com");
				userList.add(userInfo);
			}
		}
		return userList;
	}
}
