/*
 * The MIT License
 *
 * Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.listview_array_adapter_custom_class;

import android.app.ListActivity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import java.util.ArrayList;
import java.util.List;

public class UserListActivity extends ListActivity
	implements OnClickListener
{

	private static final int USER_EDIT_ACTIVITY = 1;
	private UserListAdapter userListAdapter;
	private List<User> userList = new ArrayList<User>();

	@Override
	public void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.user_list_activity);

		// Init data list
		userList = new ArrayList<User>();

		// Init list adapter
		userListAdapter = new UserListAdapter(this, userList);
		setListAdapter(userListAdapter);

		Button addButton = (Button) findViewById(R.id.add_button);
		addButton.setOnClickListener(this);
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data)
	{
		if (requestCode == USER_EDIT_ACTIVITY)
		{
			if (resultCode == RESULT_OK)
			{
				User user = (User) data.getSerializableExtra(UserEditActivity.EXTRA_USER);
				userList.add(user);
				userListAdapter.notifyDataSetChanged();
			}
		}
	}

	public void onClick(View view)
	{
		switch (view.getId())
		{
			case R.id.add_button:
				Intent intent = new Intent(getApplicationContext(), UserEditActivity.class);
				startActivityForResult(intent, USER_EDIT_ACTIVITY);
				break;
		}
	}
}
