/*
 * The MIT License
 *
 * Copyright 2012 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.application_custom_hello;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;

public class MainActivity extends Activity
{

	private static final String LOG_TAG = "XXX";

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		Log.v(LOG_TAG, "MainActivity#onCreate() : Hello");
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main_activity);
		Log.v(LOG_TAG, "MainActivity#onCreate() : Bye");
	}

	@Override
	protected void onDestroy()
	{
		Log.v(LOG_TAG, "MainActivity#onDestroy() : Hello");
		super.onDestroy();
		Log.v(LOG_TAG, "MainActivity#onDestroy() : Bye");
	}

	@Override
	protected void onResume()
	{
		Log.v(LOG_TAG, "MainActivity#onResume() : Hello");
		super.onResume();
		Log.v(LOG_TAG, "MainActivity#onResume() : Bye");
	}

	@Override
	protected void onPause()
	{
		Log.v(LOG_TAG, "MainActivity#onPause() : Hello");
		super.onPause();
		Log.v(LOG_TAG, "MainActivity#onPause() : Bye");
	}
}
