package com.example.hello.android.viewflipper_flipping;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.ViewFlipper;

public class MainActivity extends Activity implements OnClickListener
{

	private ViewFlipper viewFlipper;
	private Button startButton;
	private Button stopButton;

	@Override
	public void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main_activity);
		viewFlipper = (ViewFlipper) findViewById(R.id.viewflipper);
		viewFlipper.setFlipInterval(1000);

		startButton = (Button) findViewById(R.id.start_button);
		startButton.setOnClickListener(this);

		stopButton = (Button) findViewById(R.id.stop_button);
		stopButton.setOnClickListener(this);
		stopButton.setEnabled(false);
	}

	public void onClick(View v)
	{
		switch (v.getId())
		{
			case R.id.start_button:
				startButton.setEnabled(false);
				viewFlipper.startFlipping();
				stopButton.setEnabled(true);
				break;
			case R.id.stop_button:
				stopButton.setEnabled(false);
				viewFlipper.stopFlipping();
				startButton.setEnabled(true);
				break;
		}
	}
}
