/*
 * The MIT License
 *
 * Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.ui_pattern_listview_crud_array;

import android.app.Activity;
import android.content.Intent;
import android.widget.TextView;

/**
 *
 * @author Masahiko, SAWAI <masahiko.sawai@gmail.com>
 */
public class UserDetailUtils implements UserConstants
{

	static void loadValuesFromIntent(Activity activity, Intent dataIntent)
	{
		TextView idTextView = (TextView) activity.findViewById(R.id.id_textview);
		TextView firstNameTextView = (TextView) activity.findViewById(R.id.first_name_textview);
		TextView lastNameTextView = (TextView) activity.findViewById(R.id.last_name_textview);
		TextView emailTextView = (TextView) activity.findViewById(R.id.email_textview);
		TextView ageTextView = (TextView) activity.findViewById(R.id.age_textview);

		int id = dataIntent.getIntExtra(EXTRA_ID, -1);
		String firstName = dataIntent.getStringExtra(EXTRA_FIRST_NAME);
		String lastName = dataIntent.getStringExtra(EXTRA_LAST_NAME);
		String email = dataIntent.getStringExtra(EXTRA_EMAIL);
		int age = dataIntent.getIntExtra(EXTRA_AGE, -1);

		idTextView.setText(String.valueOf(id));
		firstNameTextView.setText(firstName);
		lastNameTextView.setText(lastName);
		emailTextView.setText(email);
		if (age != -1)
		{
			ageTextView.setText(String.valueOf(age));
		}
	}

	static void saveValuesToIntent(Activity activity, Intent dataIntent)
	{
		TextView idTextView = (TextView) activity.findViewById(R.id.id_textview);
		TextView firstNameTextView = (TextView) activity.findViewById(R.id.first_name_textview);
		TextView lastNameTextView = (TextView) activity.findViewById(R.id.last_name_textview);
		TextView emailTextView = (TextView) activity.findViewById(R.id.email_textview);
		TextView ageTextView = (TextView) activity.findViewById(R.id.age_textview);

		String idText = idTextView.getText().toString();
		int id = Integer.parseInt(idText);
		String firstName = firstNameTextView.getText().toString();
		String lastName = lastNameTextView.getText().toString();
		String email = emailTextView.getText().toString();
		String ageText = ageTextView.getText().toString();
		int age = Integer.parseInt(ageText);

		dataIntent.putExtra(EXTRA_ID, id);
		dataIntent.putExtra(EXTRA_FIRST_NAME, firstName);
		dataIntent.putExtra(EXTRA_LAST_NAME, lastName);
		dataIntent.putExtra(EXTRA_EMAIL, email);
		dataIntent.putExtra(EXTRA_AGE, age);
	}
}
