package com.example.hello.android.service_bind_with_aidl;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

public class MainActivity extends Activity
	implements ServiceConnection, OnClickListener
{

	public static final String LOG_TAG = "XXX";
	public static final int DELAY_TIME_IN_MSEC = 1000;
	private ICountDownService countDownService;
	private Handler handler = new Handler();
	private Runnable updateCountTask = new Runnable()
	{
		public void run()
		{
			updateCountText();
			handler.postDelayed(this, DELAY_TIME_IN_MSEC);
		}
	};

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		Log.d(LOG_TAG, "MainActivity#onCreate() Hello");
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		Button startServiceButton = (Button) findViewById(R.id.start_count_button);
		startServiceButton.setOnClickListener(this);
		Button stopServiceButton = (Button) findViewById(R.id.stop_count_button);
		stopServiceButton.setOnClickListener(this);

		Log.d(LOG_TAG, "MainActivity#onCreate() Bye");
	}

	@Override
	protected void onStart()
	{
		Log.d(LOG_TAG, "MainActivity#onStart() Bye");
		super.onStart();
		Intent intent = new Intent(this, CountDownService.class);
		bindService(intent, this, BIND_AUTO_CREATE);
		Log.d(LOG_TAG, "MainActivity#onStart() Bye");
	}

	@Override
	protected void onStop()
	{
		Log.d(LOG_TAG, "MainActivity#onStop() Hello");
		unbindService(this);
		super.onStop();
		Log.d(LOG_TAG, "MainActivity#onStop() Bye");
	}

	@Override
	protected void onResume()
	{
		Log.d(LOG_TAG, "MainActivity#onResume() Hello");
		super.onResume();
		handler.postDelayed(updateCountTask, DELAY_TIME_IN_MSEC);
		Log.d(LOG_TAG, "MainActivity#onResume() Bye");
	}

	@Override
	protected void onPause()
	{
		Log.d(LOG_TAG, "MainActivity#onPause() Hello");
		handler.removeCallbacks(updateCountTask);
		super.onPause();
		Log.d(LOG_TAG, "MainActivity#onPause() Bye");
	}

	/**
	 * ServiceConnection
	 *
	 * @param cn
	 * @param ib
	 */
	@Override
	public void onServiceConnected(ComponentName cn, IBinder ib)
	{
		Log.d(LOG_TAG, "MainActivity#onServiceConnected() Hello");
		countDownService = ICountDownService.Stub.asInterface(ib);
		Log.d(LOG_TAG, "MainActivity#onServiceConnected() Bye");
	}

	/**
	 * ServiceConnection
	 *
	 * @param cn
	 */
	@Override
	public void onServiceDisconnected(ComponentName cn)
	{
		Log.d(LOG_TAG, "MainActivity#onServiceDisconnected() Hello");
		countDownService = null;
		Log.d(LOG_TAG, "MainActivity#onServiceDisconnected() Bye");
	}

	public void onClick(View view)
	{
		switch (view.getId())
		{
			case R.id.start_count_button:
				startCountDownService();
				break;
			case R.id.stop_count_button:
				stopCountDownService();
				break;
		}
	}

	private void updateCountText()
	{
		Log.v(LOG_TAG, "MainActivity#updateCountText() : Hello");

		if (countDownService != null)
		{
			try
			{
				int count = countDownService.getCount();
				TextView countTextView = (TextView) findViewById(R.id.count_textview);
				countTextView.setText(String.valueOf(count));
			}
			catch (RemoteException ex)
			{
				Log.e(LOG_TAG, "Getting count failed.", ex);
			}
		}

		Log.v(LOG_TAG, "MainActivity#updateCountText() : bye");
	}

	private void startCountDownService()
	{
		Log.v(LOG_TAG, "MainActivity#startCountDownService() : Hello");

		Toast.makeText(getApplicationContext(), "Start count down!", Toast.LENGTH_SHORT).show();
		if (countDownService != null)
		{
			try
			{
				countDownService.startCountDown();
			}
			catch (RemoteException ex)
			{
				Log.e(LOG_TAG, "Count down starting failed.", ex);
			}
		}

		Log.v(LOG_TAG, "MainActivity#startCountDownService() : Bye");
	}

	private void stopCountDownService()
	{
		Log.v(LOG_TAG, "MainActivity#stopCountDownService() : Hello");

		Toast.makeText(getApplicationContext(), "Stop count down!", Toast.LENGTH_SHORT).show();
		if (countDownService != null)
		{
			try
			{
				countDownService.stopCountDown();
			}
			catch (RemoteException ex)
			{
				Log.e(LOG_TAG, "Count down stopping failed.", ex);
			}
		}

		Log.v(LOG_TAG, "MainActivity#stopCountDownService() : Bye");
	}
}
