/*
 * The MIT License
 *
 * Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.listview_single_choice_checkable_layout;

import android.app.ListActivity;
import android.os.Bundle;
import android.util.Log;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SimpleAdapter;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MainActivity extends ListActivity
{

	private static final String LOG_TAG = "XXX";
	private static final String MAPPING_KEY_NAME = "name";
	private static final String MAPPING_KEY_EMAIL = "email";
	private static final String[] MAPPING_FROM =
	{
		MAPPING_KEY_NAME,
		MAPPING_KEY_EMAIL,
	};
	private static final int[] MAPPING_TO =
	{
		R.id.name,
		R.id.email,
	};
	private List<Map<String, String>> userList;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main_activity);

		// Init ListAdapter
		ListAdapter listAdapter = new SimpleAdapter(this, getUserList(),
			R.layout.user_list_item,
			MAPPING_FROM, MAPPING_TO);
		setListAdapter(listAdapter);

		// Init ListView choice mode & default checked item
		ListView listView = getListView();
		listView.setChoiceMode(ListView.CHOICE_MODE_SINGLE);
		listView.setItemChecked(2, true);
	}

	@Override
	protected void onPause()
	{
		showCheckedUser();

		super.onPause();
	}

	private List<Map<String, String>> getUserList()
	{
		if (userList == null)
		{
			userList = new ArrayList<Map<String, String>>();
			String[] userNames = getResources().getStringArray(R.array.names);
			for (String name : userNames)
			{
				String email = name.toLowerCase() + "@example.com";
				Map<String, String> userData = new HashMap<String, String>();
				userData.put(MAPPING_KEY_NAME, name);
				userData.put(MAPPING_KEY_EMAIL, email);
				userList.add(userData);
			}
		}
		return userList;
	}

	private void showCheckedUser()
	{
		int checkedItemPosition = getListView().getCheckedItemPosition();
		Log.d(LOG_TAG, "checkedItemPosition => " + checkedItemPosition);
		if (checkedItemPosition >= 0 && checkedItemPosition < userList.size())
		{
			Map<String, String> userData = userList.get(checkedItemPosition);
			String name = userData.get(MAPPING_KEY_NAME);
			String email = userData.get(MAPPING_KEY_EMAIL);
			String message = String.format("Checked User : name => %s, email => %s", name, email);
			Log.d(LOG_TAG, message);
			Toast.makeText(this, message, Toast.LENGTH_SHORT).show();
		}
	}
}
