/*
 * The MIT License
 *
 * Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.listview_layout_sample;

import android.app.ListActivity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class MainActivity extends ListActivity
	implements OnItemClickListener
{

	public static final String LOG_TAG = "XXX";
	private static final String[] LIST_ITEM_LAYOUT_NAMES;
	private static final Integer[] LIST_ITEM_LAYOUT_ID;

	static
	{
		Class layoutClass = android.R.layout.class;
		List<String> layoutNameList = new ArrayList<String>();
		List<Integer> layoutIdList = new ArrayList<Integer>();
		for (Field field : layoutClass.getDeclaredFields())
		{
			try
			{
				String layoutName = field.getName();
				if (layoutName.indexOf("list_item") > 0)
				{
					int layoutID = field.getInt(null);
					layoutNameList.add(layoutName);
					layoutIdList.add(layoutID);
				}
			}
			catch (IllegalArgumentException ex)
			{
				Log.e("android.R:ContenColorDBHelper", "access denied.", ex);
			}
			catch (IllegalAccessException ex)
			{
				Log.e("android.R:ContenColorDBHelper", "access denied.", ex);
			}
		}
		LIST_ITEM_LAYOUT_NAMES = layoutNameList.toArray(new String[0]);
		LIST_ITEM_LAYOUT_ID = layoutIdList.toArray(new Integer[0]);

	}

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.list_activity);

		// Init ArrayAdapter
		ArrayAdapter<String> arrayAdapter = new ArrayAdapter<String>(this,
			android.R.layout.simple_list_item_1,
			LIST_ITEM_LAYOUT_NAMES);
		setListAdapter(arrayAdapter);

		// set item click listener
		ListView listView = (ListView) findViewById(android.R.id.list);
		listView.setOnItemClickListener(this);

	}

	public void onItemClick(AdapterView<?> parentView, View itemView, int position, long id)
	{
		Log.d(LOG_TAG, "onClick() : layout name =>" + LIST_ITEM_LAYOUT_NAMES[position]
			+ ", layout id =>" + LIST_ITEM_LAYOUT_ID[position]);

		startSampleListViewActivity(position);
	}

	private void startSampleListViewActivity(int position)
	{
		Intent intent = new Intent(MainActivity.this, LayoutSampleActivity.class);
		intent.putExtra(LayoutSampleActivity.EXTRA_LAYOUT_NAME, LIST_ITEM_LAYOUT_NAMES[position]);
		intent.putExtra(LayoutSampleActivity.EXTRA_LAYOUT_ID, LIST_ITEM_LAYOUT_ID[position]);
		startActivity(intent);
	}
}
