/*
 * The MIT License
 *
 * Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.listview_array_adapter_custom_class;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;
import java.util.List;

public class UserListAdapter extends ArrayAdapter<User>
{

	private LayoutInflater inflater;

	public UserListAdapter(Context context, List<User> userList)
	{
		super(context, R.layout.user_list_item, userList);
		inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent)
	{
		View view;

		if (convertView == null)
		{
			view = inflater.inflate(R.layout.user_list_item, null);
		}
		else
		{
			view = convertView;
		}

		User user = getItem(position);
		if (user != null)
		{
			TextView firstNameTextView = (TextView) view.findViewById(R.id.first_name_textview);
			firstNameTextView.setText(user.getFirstName());

			TextView lastNameTextView = (TextView) view.findViewById(R.id.last_name_textview);
			lastNameTextView.setText(user.getLastName());

			TextView ageTextView = (TextView) view.findViewById(R.id.age_textview);
			ageTextView.setText(String.valueOf(user.getAge()));

			String email = user.getEmail();
			TextView emailTextView = (TextView) view.findViewById(R.id.email_textview);
			if (email != null)
			{
				emailTextView.setText(email);
			}
			else
			{
				emailTextView.setText(R.string.email_none);
			}
		}
		return view;
	}
}
