/*
 * The MIT License
 *
 * Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.intent_service_hello;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.Toast;

public class MainActivity extends Activity implements OnClickListener
{

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		Button startCountDownButton = (Button) findViewById(R.id.start_count_down_button);
		startCountDownButton.setOnClickListener(this);

		Button startCountDown3Button = (Button) findViewById(R.id.start_count_down_3_button);
		startCountDown3Button.setOnClickListener(this);
	}

	public void onClick(View view)
	{
		Intent intent;
		switch (view.getId())
		{
			case R.id.start_count_down_button:
				Toast.makeText(getApplicationContext(), "Start Count Down!", Toast.LENGTH_SHORT).show();
				intent = new Intent(MainActivity.this, CountDownService.class);
				startService(intent);
				break;
			case R.id.start_count_down_3_button:
				Toast.makeText(getApplicationContext(), "Start Count Down 3!", Toast.LENGTH_SHORT).show();
				intent = new Intent(MainActivity.this, CountDownService.class);
				intent.putExtra(CountDownService.EXTRA_COUNT, 3);
				startService(intent);
				break;
		}
	}
}
