package com.example.hello.android.fragment_lifecycle;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;

public class MainActivity extends Activity
{

	private static final String LOG_TAG = "MainActivity";

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		Log.v(LOG_TAG, "onCreate() : Hello");
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main_activity);
		Log.v(LOG_TAG, "onCreate() : Bye");
	}

	@Override
	protected void onStart()
	{
		Log.v(LOG_TAG, "onStart() : Hello");
		super.onStart();
		Log.v(LOG_TAG, "onStart() : Bye");
	}

	@Override
	protected void onResume()
	{
		Log.v(LOG_TAG, "onResume() : Hello");
		super.onResume();
		Log.v(LOG_TAG, "onResume() : Bye");
	}

	@Override
	protected void onPause()
	{
		Log.v(LOG_TAG, "onPause() : Hello");
		super.onPause();
		Log.v(LOG_TAG, "onPause() : Bye");
	}

	@Override
	protected void onStop()
	{
		Log.v(LOG_TAG, "onStop() : Hello");
		super.onStop();
		Log.v(LOG_TAG, "onStop() : Bye");
	}

	@Override
	protected void onDestroy()
	{
		Log.v(LOG_TAG, "onDestroy() : Hello");
		super.onDestroy();
		Log.v(LOG_TAG, "onDestroy() : Bye");
	}
}
