/*
 * The MIT License
 *
 * Copyright 2013 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.preference_auto_summary;

import android.content.ContentResolver;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.net.Uri;
import android.preference.EditTextPreference;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceGroup;
import android.preference.PreferenceScreen;
import android.preference.RingtonePreference;
import android.provider.MediaStore;
import android.util.Log;

/**
 *
 * @author Masahiko, SAWAI <masahiko.sawai@gmail.com>
 */
public class PreferenceSummaryAutoUpdater
	implements SharedPreferences.OnSharedPreferenceChangeListener
{

	private static final String LOG_TAG = "XXX";
	private PreferenceActivity preferneceActivity;

	public PreferenceSummaryAutoUpdater(PreferenceActivity preferneceActivity)
	{
		this.preferneceActivity = preferneceActivity;
	}

	public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String preferenceKey)
	{
		Log.v(LOG_TAG, "PreferenceSummaryAutoUpdater#onSharedPreferenceChanged() : Hello");

		PreferenceScreen preferenceScreen = preferneceActivity.getPreferenceScreen();
		Preference preference = preferenceScreen.findPreference(preferenceKey);
		this.updatePreferenceSummary(sharedPreferences, preference);

		Log.v(LOG_TAG, "PreferenceSummaryAutoUpdater#onSharedPreferenceChanged() : Bye");
	}

	public void updateAllSummary()
	{
		Log.v(LOG_TAG, "PreferenceSummaryAutoUpdater#updateAllSummary() : Hello");
		updatePreferenceGroupSummary(this.preferneceActivity.getPreferenceScreen());
		Log.v(LOG_TAG, "PreferenceSummaryAutoUpdater#updateAllSummary() : Bye");
	}

	public void updatePreferenceGroupSummary(PreferenceGroup preferenceGroup)
	{
		Log.v(LOG_TAG, "PreferenceSummaryAutoUpdater#updateAllSummary() : Hello");
		SharedPreferences sharedPreferences = preferenceGroup.getSharedPreferences();
		int preferenceCount = preferenceGroup.getPreferenceCount();
		Log.v(LOG_TAG, "PreferenceSummaryAutoUpdater#updateAllSummary() : preferenceCount => " + preferenceCount);
		for (int i = 0; i < preferenceCount; i++)
		{
			Preference preference = preferenceGroup.getPreference(i);
			if (preference instanceof PreferenceGroup)
			{
				PreferenceGroup group = (PreferenceGroup) preference;
				updatePreferenceGroupSummary(group);
			}
			else
			{
				this.updatePreferenceSummary(sharedPreferences, preference);
			}
		}
		Log.v(LOG_TAG, "PreferenceSummaryAutoUpdater#updateAllSummary() : Bye");
	}

	private void updatePreferenceSummary(SharedPreferences sharedPreferences, Preference preference)
	{
		Log.v(LOG_TAG, "PreferenceSummaryAutoUpdater#updatePreferenceSummary() : Hello");
		String preferenceKey = preference.getKey();
		if (preference instanceof EditTextPreference)
		{
			Log.v(LOG_TAG, "PreferenceSummaryAutoUpdater#updatePreferenceSummary() : EditTextPreference");
			EditTextPreference editTextPreference = (EditTextPreference) preference;
			String stringValue = sharedPreferences.getString(preferenceKey, null);
			if (stringValue != null)
			{
				editTextPreference.setSummary(stringValue);
			}
		}
		else if (preference instanceof ListPreference)
		{
			Log.v(LOG_TAG, "PreferenceSummaryAutoUpdater#updatePreferenceSummary() : ListPreference");
			ListPreference listPreference = (ListPreference) preference;
			CharSequence entry = listPreference.getEntry();
			if (entry != null)
			{
				listPreference.setSummary(entry);
			}
		}
		else if (preference instanceof RingtonePreference)
		{
			Log.v(LOG_TAG, "PreferenceSummaryAutoUpdater#updatePreferenceSummary() : RingtonePreference");
			RingtonePreference ringtonePreference = (RingtonePreference) preference;
			String ringtoneUriString = sharedPreferences.getString(preferenceKey, null);
			Log.v(LOG_TAG, "PreferenceSummaryAutoUpdater#updatePreferenceSummary() : ringtoneUriString => " + ringtoneUriString);
			if (ringtoneUriString != null)
			{
				Uri ringtoneUri = Uri.parse(ringtoneUriString);
				Log.v(LOG_TAG, "PreferenceSummaryAutoUpdater#updatePreferenceSummary() : ringtoneUri => " + ringtoneUri);
				ContentResolver contentResolver = preferneceActivity.getContentResolver();
				String type = contentResolver.getType(ringtoneUri);
				Log.v(LOG_TAG, "PreferenceSummaryAutoUpdater#updatePreferenceSummary() : type => " + type);
				Cursor cursor = null;
				try
				{
					cursor = contentResolver.query(ringtoneUri, new String[]
						{
							MediaStore.MediaColumns.TITLE
						}, null, null, null);
					Log.v(LOG_TAG, "PreferenceSummaryAutoUpdater#updatePreferenceSummary() : cursor => " + cursor);
					if (cursor != null && cursor.moveToFirst())
					{
						int titleIndex = cursor.getColumnIndex(MediaStore.MediaColumns.TITLE);
						Log.v(LOG_TAG, "PreferenceSummaryAutoUpdater#updatePreferenceSummary() : titleIndex => " + titleIndex);
						String ringtoneTitle = cursor.getString(titleIndex);
						Log.v(LOG_TAG, "PreferenceSummaryAutoUpdater#updatePreferenceSummary() : ringtoneTitle => " + ringtoneTitle);
						ringtonePreference.setSummary(ringtoneTitle);
					}
				}
				catch (Exception ex)
				{
					Log.e(LOG_TAG, "PreferenceSummaryAutoUpdater#updatePreferenceSummary() : " + ex.getMessage(), ex);
					ringtonePreference.setSummary("");
				}
				finally
				{
					if (cursor != null)
					{
						cursor.close();
					}
				}
			}
			else
			{
				ringtonePreference.setSummary("");
			}
		}

		Log.v(LOG_TAG, "PreferenceSummaryAutoUpdater#updatePreferenceSummary() : Bye");
	}
}
