/*
 * The MIT License
 *
 * Copyright 2012 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.appwidget_with_config_activity;

import android.app.Activity;
import android.appwidget.AppWidgetManager;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RemoteViews;

/**
 *
 */
public class HelloAppWidgetConfigureActivity extends Activity
	implements View.OnClickListener
{

	private int appWidgetId = AppWidgetManager.INVALID_APPWIDGET_ID;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.hello_appwidget_configure_activity);

		// Init appWidgetId
		Intent intent = getIntent();
		Bundle extras = intent.getExtras();
		if (extras != null)
		{
			appWidgetId = extras.getInt(AppWidgetManager.EXTRA_APPWIDGET_ID);
		}

		if (appWidgetId == AppWidgetManager.INVALID_APPWIDGET_ID)
		{
			setResult(RESULT_CANCELED);
			finish();
		}

		Button okButton = (Button) findViewById(R.id.ok_button);
		okButton.setOnClickListener(this);
		Button cancelButton = (Button) findViewById(R.id.cancel_button);
		cancelButton.setOnClickListener(this);
	}

	public void onClick(View v)
	{
		switch (v.getId())
		{
			case R.id.ok_button:
				onOkClicked();
				break;
			case R.id.cancel_button:
				onCancelClicked();
				break;
		}
	}

	private void onOkClicked()
	{
		EditText messageEditText = (EditText) findViewById(R.id.message_edittext);
		String message = messageEditText.getText().toString();

		// 設定画面を起動した場合 onUpdate() は自動で呼ばれないので明示的に呼ぶ
		RemoteViews remoteViews = new RemoteViews(getPackageName(), R.layout.hello_appwidget);
		if (!TextUtils.isEmpty(message))
		{
			remoteViews.setTextViewText(R.id.message_textview, message);
		}
		AppWidgetManager manager = AppWidgetManager.getInstance(this);
		manager.updateAppWidget(appWidgetId, remoteViews);

		Intent resultIntent = new Intent();
		resultIntent.putExtra(AppWidgetManager.EXTRA_APPWIDGET_ID, appWidgetId);
		setResult(RESULT_OK, resultIntent);
		finish();
	}

	private void onCancelClicked()
	{
		setResult(RESULT_CANCELED);
		finish();
	}
}
