/*
 * The MIT License
 *
 * Copyright 2013 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.view_custom_drawing_animation;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.Window;
import android.view.WindowManager;

public class MainActivity extends Activity
{

	private static final String LOG_TAG = "XXX";
	private static final int DELAY_TIME_IN_MSEC = 30; // 33 fps?
	private static final String SAVE_KEY_LINEART = "LineArt";
	private LineArt lineArt;
	private LineArtView lineArtView;
	private RepaintTask repaintTask;
	private Handler handler;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		Log.d(LOG_TAG, "onCreate()");
		super.onCreate(savedInstanceState);
		requestWindowFeature(Window.FEATURE_NO_TITLE);
		getWindow().setFlags(
			WindowManager.LayoutParams.FLAG_FULLSCREEN,
			WindowManager.LayoutParams.FLAG_FULLSCREEN);

		// init LineArt
		Log.d(LOG_TAG, "savedInstanceState : " + savedInstanceState);
		if (savedInstanceState != null)
		{
			lineArt = (LineArt) savedInstanceState.getSerializable(SAVE_KEY_LINEART);
			Log.d(LOG_TAG, "load LineArt from savedInstanceState");
		}
		if (lineArt == null)
		{
			lineArt = new LineArt();
			Log.d(LOG_TAG, "new LineArt");
		}

		// init View
		lineArtView = new LineArtView(this);
		lineArtView.setLineArt(lineArt);
		setContentView(lineArtView);

		repaintTask = new RepaintTask();
		handler = new Handler();
	}

	@Override
	protected void onSaveInstanceState(Bundle outState)
	{
		Log.d(LOG_TAG, "onSaveInstanceState()");
		super.onSaveInstanceState(outState);
		outState.putSerializable(SAVE_KEY_LINEART, lineArt);
	}

	@Override
	protected void onPause()
	{
		Log.d(LOG_TAG, "onPause()");
		repaintTask.setEnable(false);
		handler.removeCallbacks(repaintTask);
		super.onPause();
	}

	@Override
	protected void onResume()
	{
		Log.d(LOG_TAG, "onResume()");
		super.onResume();
		repaintTask.setEnable(true);
		handler.postDelayed(repaintTask, DELAY_TIME_IN_MSEC);
	}

	class RepaintTask implements Runnable
	{

		private boolean enable = false;

		public void run()
		{
//			Log.d(LOG_TAG, "run()");
			if (enable)
			{
				lineArtView.invalidate();
				handler.postDelayed(this, DELAY_TIME_IN_MSEC);
			}
		}

		/**
		 * @return the enable
		 */
		public boolean getEnable()
		{
			return enable;
		}

		/**
		 * @param value the isRunning to set
		 */
		public void setEnable(boolean value)
		{
			this.enable = value;
		}
	}
}
