/*
 * The MIT License
 *
 * Copyright 2013 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.imageview_zoom;

import android.app.Activity;
import android.graphics.Matrix;
import android.os.Bundle;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;

public class MainActivity extends Activity
	implements View.OnClickListener
{

	private static final String LOG_TAG = "XXX";
	private float scale = 1.0f;
	private float translateX, translateY;
	private float startX, startY;

	public void onClick(View v)
	{
		switch (v.getId())
		{
			case R.id.zoom_in_button:
				zoomIn();
				break;
			case R.id.zoom_out_button:
				zoomOut();
				break;
		}
	}

	@Override
	public boolean onTouchEvent(MotionEvent event)
	{
		switch (event.getAction())
		{
			case MotionEvent.ACTION_DOWN:
				startX = event.getX();
				startY = event.getY();
				break;
			case MotionEvent.ACTION_MOVE:
				moveImage(event);
				break;
		}
		return super.onTouchEvent(event);
	}

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		Button zoomInButton = (Button) findViewById(R.id.zoom_in_button);
		zoomInButton.setOnClickListener(this);
		Button zoomOutButton = (Button) findViewById(R.id.zoom_out_button);
		zoomOutButton.setOnClickListener(this);
	}

	private void updateMatrix()
	{
		ImageView sampleImageView = (ImageView) findViewById(R.id.sample_imageview);
		Matrix imageMatrix = new Matrix();
		imageMatrix.postScale(scale, scale, sampleImageView.getWidth() / 2, sampleImageView.getHeight() / 2);
		imageMatrix.postTranslate(translateX, translateY);
		sampleImageView.setScaleType(ImageView.ScaleType.MATRIX);
		sampleImageView.setImageMatrix(imageMatrix);
		sampleImageView.invalidate();
	}

	private void zoomIn()
	{
		Log.v(LOG_TAG, "zoomIn() : Hello");

		scale = scale * 1.2f;
		if (scale > 10)
		{
			scale = 10.0f;
		}
		Log.v(LOG_TAG, "zoomIn() : scale => " + scale);

		updateMatrix();

		Log.v(LOG_TAG, "zoomIn() : Bye");
	}

	private void zoomOut()
	{
		Log.v(LOG_TAG, "zoomOut() : Hello");

		scale = scale * 0.8f;
		if (scale < 0.2)
		{
			scale = 0.2f;
		}
		Log.v(LOG_TAG, "zoomOut() : scale => " + scale);

		updateMatrix();

		Log.v(LOG_TAG, "zoomOut() : Bye");
	}

	private void moveImage(MotionEvent event)
	{
		Log.v(LOG_TAG, "moveImage() : Hello");

		float x = event.getX();
		float y = event.getY();
		translateX += x - startX;
		translateY += y - startY;
		Log.d(LOG_TAG, "translateX => " + translateX + ", translateY => " + translateY);
		updateMatrix();

		startX = x;
		startY = y;

		Log.v(LOG_TAG, "moveImage() : Bye");
	}
}
