/*
 *  The MIT License
 *
 *  Copyright 2013 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package org.routine_work.simple_battery_logger.dropbox_uploader;

import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.preference.EditTextPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.view.MenuItem;
import org.routine_work.util.Log;
import org.routine_work.util.SystemResourceUtils;

public class DropboxUploaderPreferenceActivity extends PreferenceActivity
	implements SharedPreferences.OnSharedPreferenceChangeListener
{

	private static final String LOG_TAG = "simple-battery-logger-dropbox";

	@Override
	public boolean onOptionsItemSelected(MenuItem item)
	{
		boolean result = true;
		Log.v(LOG_TAG, "Hello");

		if (item.getItemId() == SystemResourceUtils.getResourceId("android.R$id.home"))
		{
			Log.d(LOG_TAG, "home is clicked.");
			backToDashboardActivity();
		}
		else
		{
			result = super.onOptionsItemSelected(item);
		}

		Log.v(LOG_TAG, "Bye");
		return result;
	}

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		Log.v(LOG_TAG, "Hello");

		super.onCreate(savedInstanceState);
		PreferenceUtils.getDeviceName(this);

		addPreferencesFromResource(R.xml.preferences);
		updateAllSummary();

		Log.v(LOG_TAG, "Bye");
	}

	@Override
	protected void onResume()
	{
		super.onResume();
		SharedPreferences preferences = getPreferenceScreen().getSharedPreferences();
		preferences.registerOnSharedPreferenceChangeListener(this);

		updatePreferenceEnabled();
	}

	@Override
	protected void onPause()
	{
		SharedPreferences preferences = getPreferenceScreen().getSharedPreferences();
		preferences.unregisterOnSharedPreferenceChangeListener(this);
		super.onPause();
	}

	public void onSharedPreferenceChanged(SharedPreferences prefs, String key)
	{
		Log.v(LOG_TAG, "Hello");
		Log.i(LOG_TAG, "shared preference " + key + " is changed.");

		final String csvAutoUploadEnabledKey = getString(R.string.csv_auto_upload_enabled_key);
		if (csvAutoUploadEnabledKey.equals(key))
		{
			// update component enable/disable
			boolean defaultValue = getResources().getBoolean(R.bool.csv_auto_upload_enabled_default_value);
			boolean receiveTextEnabled = prefs.getBoolean(key, defaultValue);
			int newState;

			if (receiveTextEnabled)
			{
				newState = PackageManager.COMPONENT_ENABLED_STATE_ENABLED;
				Log.d(LOG_TAG, "Enable ExportCsvFileCompletedReceiver component");
			}
			else
			{
				newState = PackageManager.COMPONENT_ENABLED_STATE_DISABLED;
				Log.d(LOG_TAG, "Disable ExportCsvFileCompletedReceiver component");
			}

			PackageManager packageManager = getPackageManager();
			ComponentName componentName = new ComponentName(this, CsvFileUploadStarter.class);
			packageManager.setComponentEnabledSetting(componentName, newState, PackageManager.DONT_KILL_APP); // dont stop
		}

		updateSummary(key);

		Log.v(LOG_TAG, "Bye");
	}

	private void updateAllSummary()
	{
		updateSummary(null);
	}

	private void updateSummary(String key)
	{
		final String deviceNameNameKey = getString(R.string.device_name_key);
		if (key == null || key.equals(deviceNameNameKey))
		{
			EditTextPreference uploadFolderNamePreference = (EditTextPreference) getPreferenceScreen().findPreference(deviceNameNameKey);
			String uploadFolderName = PreferenceUtils.getDeviceName(this);
			String summary = getString(R.string.device_name_summary, uploadFolderName);
			uploadFolderNamePreference.setSummary(summary);
		}
	}

	private void updatePreferenceEnabled()
	{
		boolean isLinkedDropboxAccount = (PreferenceUtils.getAccessTokenPair(this) != null);

		final String csvAutoUploadEnabledKey = getString(R.string.csv_auto_upload_enabled_key);
		Preference csvAutoUploadPreference = getPreferenceScreen().findPreference(csvAutoUploadEnabledKey);
		csvAutoUploadPreference.setEnabled(isLinkedDropboxAccount);

		final String uploadCsvFilesKey = getString(R.string.upload_csv_files_key);
		Preference uploadCsvFilePreference = getPreferenceScreen().findPreference(uploadCsvFilesKey);
		uploadCsvFilePreference.setEnabled(isLinkedDropboxAccount);

	}

	private void backToDashboardActivity()
	{
		Intent dashboardIntent = new Intent(Intent.ACTION_VIEW);
		dashboardIntent.setClassName("org.routine_work.simple_battery_logger", "org.routine_work.simple_battery_logger.DashboardActivity");
		dashboardIntent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
		try
		{
			startActivity(dashboardIntent);
		}
		catch (ActivityNotFoundException e)
		{
			Log.w(LOG_TAG, "DashboardActivity not found. component => " + dashboardIntent.getComponent(), e);
			finish();
		}
	}
}