/*
 * The MIT License
 *
 * Copyright 2013 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.routine_work.simple_battery_logger.dropbox_uploader;

import android.content.Context;
import android.text.format.DateFormat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.CheckedTextView;
import android.widget.TextView;
import java.util.List;

/**
 *
 * @author Masahiko, SAWAI <masahiko.sawai@gmail.com>
 */
public class CsvUploadStatusListAdapter extends ArrayAdapter<CsvUploadStatus>
{

	private static final String DATETIME_FORMAT = "yyyy-MM-dd kk:mm:ss";
	private LayoutInflater inflater;

	public CsvUploadStatusListAdapter(Context context, List<CsvUploadStatus> csvUploadStatusList)
	{
		super(context, R.layout.csv_upload_status_list_item, csvUploadStatusList);
		inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent)
	{
		View listItemView;

		if (convertView == null)
		{
			listItemView = inflater.inflate(R.layout.csv_upload_status_list_item, null);
		}
		else
		{
			listItemView = convertView;
		}

		TextView csvFilenameTextView = (TextView) listItemView.findViewById(R.id.csv_filename_textview);
		TextView uploadedModifiedTextView = (TextView) listItemView.findViewById(R.id.csv_uploaded_modified_textview);
		TextView currentModifiedTextView = (TextView) listItemView.findViewById(R.id.csv_current_modified_textview);
		csvFilenameTextView.setText(null);
		uploadedModifiedTextView.setText(null);
		currentModifiedTextView.setText(null);

		CheckedTextView checkedTextView = (CheckedTextView) listItemView.findViewById(android.R.id.checkbox);
		checkedTextView.setChecked(false);

		CsvUploadStatus csvUploadStatus = getItem(position);
		if (csvUploadStatus != null)
		{
			csvFilenameTextView.setText(csvUploadStatus.getFile().getName());

			long uploadedModified = csvUploadStatus.getUploadedModified();
			if (uploadedModified != -1)
			{
				CharSequence uploadedModifiedString = DateFormat.format(DATETIME_FORMAT, uploadedModified);
				uploadedModifiedTextView.setText(uploadedModifiedString);
			}
			else
			{
				uploadedModifiedTextView.setText(R.string.not_uploaded);
			}

			long currentModified = csvUploadStatus.getCurrentModified();
			if (currentModified != -1)
			{
				CharSequence currentModifiedString = DateFormat.format(DATETIME_FORMAT, currentModified);
				currentModifiedTextView.setText(currentModifiedString);
			}
		}

		return listItemView;
	}
}