/*
 *  The MIT License
 *
 *  Copyright 2011-2012 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package org.routine_work.simple_battery_logger.util;

import org.routine_work.util.Log;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import org.routine_work.simple_battery_logger.R;

/**
 *
 * @author sawai
 */
public class PreferenceUtils
{

	private static final String LOG_TAG = "simple-battery-logger";

	/**
	 * Get private SharedPreferences
	 *
	 * @param context
	 * @return
	 */
	public static SharedPreferences getPrivateSharedPreferences(Context context)
	{
		String preferenceName = context.getPackageName() + "_preferences";
		SharedPreferences sharedPreferences = context.getSharedPreferences(preferenceName, Context.MODE_PRIVATE);
		return sharedPreferences;
	}

	/**
	 * Get public SharedPreferences
	 *
	 * This SharedPreferences is referenced by Simple Battery Logger Dropbox
	 * Uploader
	 *
	 * @param context
	 * @return
	 */
	public static SharedPreferences getExportedSharedPreference(Context context)
	{
		String exportedPreferenceName = context.getPackageName() + "_exported_preferences";
		SharedPreferences exportedSharedPreferences = context.getSharedPreferences(
			exportedPreferenceName, Context.MODE_WORLD_READABLE);
		return exportedSharedPreferences;
	}

	public static boolean isLoggingServiceEnabled(Context context)
	{
		SharedPreferences sharedPreferences = getPrivateSharedPreferences(context);
		Resources resources = context.getResources();

		String key = resources.getString(R.string.logging_service_enabled_key);
		boolean defaultValue = resources.getBoolean(R.bool.logging_service_enabled_default_value);
		boolean value = sharedPreferences.getBoolean(key, defaultValue);

		Log.v(LOG_TAG, "loggingServiceEnabled => " + value);
		return value;
	}

	public static void putLoggingServiceEnabled(Context context, boolean enabled)
	{
		Log.v(LOG_TAG, "loggingServiceEnabled => " + enabled);
		SharedPreferences sharedPreferences = getPrivateSharedPreferences(context);
		Resources resources = context.getResources();

		String key = resources.getString(R.string.logging_service_enabled_key);
		SharedPreferences.Editor editor = sharedPreferences.edit();
		editor.putBoolean(key, enabled);
		editor.commit();

	}

	public static boolean isIgnoreVoltageChangeOnly(Context context)
	{

		SharedPreferences sharedPreferences = getPrivateSharedPreferences(context);
		Resources resources = context.getResources();

		String key = resources.getString(R.string.ignore_voltage_change_only_key);
		boolean defaultValue = resources.getBoolean(R.bool.ignore_voltage_change_only_default_value);
		boolean value = sharedPreferences.getBoolean(key, defaultValue);

		Log.v(LOG_TAG, "ignoreVoltageChangeOnly => " + value);
		return value;
	}

	public static int getDataKeepingPeriod(Context context)
	{
		SharedPreferences sharedPreferences = getPrivateSharedPreferences(context);
		Resources resources = context.getResources();

		String key = resources.getString(R.string.data_keeping_period_key);
		String defaultValue = resources.getString(R.string.data_keeping_period_default_value);
		String valueString = sharedPreferences.getString(key, defaultValue);
		int dataKeepingPeriod = Integer.parseInt(valueString);

		Log.v(LOG_TAG, "dataKeepingPeriod => " + dataKeepingPeriod);
		return dataKeepingPeriod;
	}

	public static boolean isCsvAutoExportEnabled(Context context)
	{
		SharedPreferences sharedPreferences = getPrivateSharedPreferences(context);
		Resources resources = context.getResources();

		String key = resources.getString(R.string.csv_auto_export_enabled_key);
		boolean defaultValue = resources.getBoolean(R.bool.csv_auto_export_enabled_default_value);
		boolean value = sharedPreferences.getBoolean(key, defaultValue);

		Log.v(LOG_TAG, "csvAutoExportEnabled => " + value);
		return value;
	}

	public static String getCsvSortOrder(Context context)
	{
		SharedPreferences sharedPreferences = getPrivateSharedPreferences(context);
		Resources resources = context.getResources();

		String key = resources.getString(R.string.csv_sort_order_key);
		String defaultValue = resources.getString(R.string.csv_sort_order_default_value);
		String value = sharedPreferences.getString(key, defaultValue);

		Log.v(LOG_TAG, "csvSortOrder => " + value);
		return value;
	}

	public static String getCsvExportDirectoryName(Context context)
	{
		SharedPreferences sharedPreferences = getPrivateSharedPreferences(context);
		Resources resources = context.getResources();

		String key = resources.getString(R.string.csv_export_directory_key);
		String defaultValue = resources.getString(R.string.csv_export_directory_default_value);
		String value = sharedPreferences.getString(key, defaultValue);

		Log.v(LOG_TAG, "csvExportDirectory => " + value);
		return value;
	}

	/**
	 * Copy CSV Directory from private SharedPreferences to exported
	 * SharedPreferences
	 *
	 * @param context
	 */
	public static void exportCsvExportDirectoryName(Context context)
	{
		Log.v(LOG_TAG, "Hello");

		SharedPreferences exportedSharedPreferences = getExportedSharedPreference(context);
		Resources resources = context.getResources();

		// copy csvExportDirectory to exportedSharedPreferences
		String key = resources.getString(R.string.csv_export_directory_key);
		String value = getCsvExportDirectoryName(context);

		SharedPreferences.Editor edit = exportedSharedPreferences.edit();
		edit.putString(key, value);
		edit.commit();

		Log.v(LOG_TAG, "Bye");
	}

	public static boolean isCsvMediaScanCompleted(Context context)
	{
		SharedPreferences sharedPreferences = getPrivateSharedPreferences(context);
		Resources resources = context.getResources();

		String key = resources.getString(R.string.csv_media_scan_completed_key);
		boolean defaultValue = resources.getBoolean(R.bool.csv_media_scan_completed_default_value);
		boolean value = sharedPreferences.getBoolean(key, defaultValue);

		Log.v(LOG_TAG, "csvMediaScanCompleted => " + value);
		return value;
	}

	public static void putCsvMediaScanCompleted(Context context, boolean value)
	{
		Log.v(LOG_TAG, "csvMediaScanCompleted => " + value);
		SharedPreferences sharedPreferences = getPrivateSharedPreferences(context);
		Resources resources = context.getResources();

		String key = resources.getString(R.string.csv_media_scan_completed_key);
		SharedPreferences.Editor editor = sharedPreferences.edit();
		editor.putBoolean(key, value);
		editor.commit();
	}

	public static void reset(Context context)
	{
		Log.v(LOG_TAG, "Hello");

		SharedPreferences sharedPreferences = getPrivateSharedPreferences(context);
		SharedPreferences.Editor edit = sharedPreferences.edit();
		edit.clear();
		edit.commit();

		Log.v(LOG_TAG, "Bye");
	}
}
