/*
 *  The MIT License
 *
 *  Copyright 2011-2012 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package org.routine_work.simple_battery_logger.dropbox_uploader;

import org.routine_work.util.Log;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager.NameNotFoundException;
import android.content.res.Resources;
import android.os.Build;
import com.dropbox.client2.session.AccessTokenPair;

/**
 *
 * @author sawai
 */
public class PreferenceUtils
{

	private static final String LOG_TAG = "simple-battery-logger-dropbox";

	private static SharedPreferences getSharedPreferences(Context context)
	{
		String preferenceName = context.getPackageName() + "_preferences";
		Log.d(LOG_TAG, "preferenceName => " + preferenceName);
		SharedPreferences sharedPreferences = context.getSharedPreferences(preferenceName, Context.MODE_PRIVATE);
		Log.d(LOG_TAG, "sharedPreferences => " + sharedPreferences);
		return sharedPreferences;
	}

	public static AccessTokenPair getAccessTokenPair(Context context)
	{
		AccessTokenPair pair = null;

		String tokenKeyKey = context.getString(R.string.dropbox_token_key_key);
		String tokenSecretKey = context.getString(R.string.dropbox_token_secret_key);
		SharedPreferences prefs = getSharedPreferences(context);
		String tokenKey = prefs.getString(tokenKeyKey, null);
		String tokenSecret = prefs.getString(tokenSecretKey, null);
//		Log.d(LOG_TAG, "tokenKey => " + tokenKey);
//		Log.d(LOG_TAG, "tokenSecret => " + tokenSecret);
		if (tokenKey != null && tokenSecret != null)
		{
			pair = new AccessTokenPair(tokenKey, tokenSecret);
		}
//		Log.d(LOG_TAG, "pair => " + pair);

		return pair;
	}

	public static void putAccessTokenPair(Context context, AccessTokenPair tokenPair)
	{
		String tokenKey = null;
		String tokenSecret = null;
		if (tokenPair != null)
		{
			tokenKey = tokenPair.key;
			tokenSecret = tokenPair.secret;
		}
		Log.d(LOG_TAG, "tokenKey => " + tokenKey);
		Log.d(LOG_TAG, "tokenSecret => " + tokenSecret);

		String sessionKeyKey = context.getString(R.string.dropbox_token_key_key);
		String sessionSecretKey = context.getString(R.string.dropbox_token_secret_key);
		SharedPreferences prefs = getSharedPreferences(context);
		SharedPreferences.Editor editor = prefs.edit();
		editor.putString(sessionKeyKey, tokenKey);
		editor.putString(sessionSecretKey, tokenSecret);
		editor.commit();
	}

	public static String getDropboxAccountName(Context context)
	{
		SharedPreferences sharedPreferences = getSharedPreferences(context);
		Resources resources = context.getResources();

		String key = resources.getString(R.string.dropbox_account_name_key);
		String value = sharedPreferences.getString(key, null);

		Log.v(LOG_TAG, "dropbox_account_name => " + value);
		return value;
	}

	public static void putDropboxAccountName(Context context, String accountNmae)
	{
		String dropboxAccountNameKey = context.getString(R.string.dropbox_account_name_key);
		SharedPreferences prefs = getSharedPreferences(context);
		SharedPreferences.Editor editor = prefs.edit();
		editor.putString(dropboxAccountNameKey, accountNmae);
		editor.commit();
	}

	public static String getDeviceName(Context context)
	{
		SharedPreferences sharedPreferences = getSharedPreferences(context);
		Resources resources = context.getResources();

		String key = resources.getString(R.string.device_name_key);
		String value = sharedPreferences.getString(key, "");
		if (value.length() == 0)
		{
			value = Build.MANUFACTURER + "-" + Build.MODEL;
			value = value.replace(" ", "");
			SharedPreferences.Editor editor = sharedPreferences.edit();
			editor.putString(key, value);
			editor.commit();
		}

		Log.v(LOG_TAG, "deviece_name => " + value);
		return value;
	}

	public static boolean isWifiOnlyUpload(Context context)
	{
		SharedPreferences sharedPreferences = getSharedPreferences(context);
		Resources resources = context.getResources();

		String key = resources.getString(R.string.wifi_only_upload_key);
		boolean value = sharedPreferences.getBoolean(key, false);

		Log.v(LOG_TAG, "wifi_only_upload => " + value);
		return value;
	}

	public static String getCsvExportDirectoryName(Context context)
	{
		String csvExportDirectoryName = null;

		try
		{
			Context c = context.createPackageContext("org.routine_work.simple_battery_logger", Context.CONTEXT_RESTRICTED);
			Log.d(LOG_TAG, "c =>" + c);
			if (c != null)
			{
				SharedPreferences prefs = c.getSharedPreferences(
					"org.routine_work.simple_battery_logger_exported_preferences",
					Context.MODE_PRIVATE);
				Log.d(LOG_TAG, "prefs =>" + prefs);
				String csvExportDirectoryKey = context.getString(R.string.csv_export_directory_key);
				String csvExportDirectoryDefaultValue = context.getString(R.string.csv_export_directory_default_value);
				csvExportDirectoryName = prefs.getString(csvExportDirectoryKey, csvExportDirectoryDefaultValue);
				Log.d(LOG_TAG, "csvExportDirectoryName =>" + csvExportDirectoryName);
			}
		}
		catch (NameNotFoundException e)
		{
			Log.e(LOG_TAG, e.getLocalizedMessage());
		}
		return csvExportDirectoryName;
	}
}
