/*
 *  The MIT License
 *
 *  Copyright 2011 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package org.routine_work.simple_battery_logger.service;

import android.app.IntentService;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.sqlite.SQLiteDatabase;
import java.util.Date;
import org.routine_work.simple_battery_logger.R;
import org.routine_work.simple_battery_logger.db.BatteryHistoryDBHelper;
import org.routine_work.util.Log;
import org.routine_work.simple_battery_logger.util.PreferenceUtils;

/**
 *
 * @author sawai
 */
public class DeleteOldDataService extends IntentService
{
	private static final String LOG_TAG = "simple-battery-logger";

	public DeleteOldDataService(String name)
	{
		super(name);
	}

	public DeleteOldDataService()
	{
		this("DeleteOldDataService");
	}

	@Override
	protected void onHandleIntent(Intent intent)
	{
		Log.i(LOG_TAG, "DeleteOldDataService () : Start at " + new Date());

		int dataKeepingPeriod = PreferenceUtils.getDataKeepingPeriod(this);
		Log.i(LOG_TAG, "dataKeepingPeriod => " + dataKeepingPeriod);

		if (dataKeepingPeriod != 0)
		{
			try
			{
				BatteryHistoryDBHelper dbHelper = new BatteryHistoryDBHelper(this);
				try
				{
					SQLiteDatabase db = dbHelper.getWritableDatabase();
					try
					{
						dbHelper.deleteOldData(db, dataKeepingPeriod);
						dbHelper.reindex(db);
						dbHelper.vaccum(db);
					}
					finally
					{
						db.close();
					}
				}
				finally
				{
					dbHelper.close();
				}
			}
			catch (Exception e)
			{
				Log.e(LOG_TAG, "Delete all data failed.", e);
			}
		}

		Log.i(LOG_TAG, "DeleteOldDataService () : End at " + new Date());
	}
}
