



function _Graphics()
{
 this.f = _FLIP_NONE;
}
_Graphics.prototype = {
 canUseClip : function()
 {
  return (!!_context.clip);
 },
 canUseText : function()
 {
  return (!!_context.fillText);
 },
 getColorOfRGB : function( r, g, b )
 {
  return "rgb(" + r + "," + g + "," + b + ")";
 },
 setStrokeWidth : function( width )
 {
  _context.lineWidth = width;
 },
 setColor : function( color )
 {
  _color = color;
  _context.fillStyle = _color;
  _context.strokeStyle = _color;
 },
 setAlpha : function( a )
 {
  _context.globalAlpha = a / 255.0;
 },
 setROP : function( mode )
 {
  _context.globalCompositeOperation = mode;
 },
 setFont : function( size, family )
 {
  _font_size = size;
  _font_family = (family.indexOf( " " ) >= 0) ? "'" + family + "'" : family;
  _context.font = "" + _font_size + "px " + _font_family;
  _text.style.cssText = _text_style + ";font:" + _font_size + "px " + _font_family;
 },
 stringWidth : function( str )
 {
  return _stringWidth( str );
 },
 fontHeight : function()
 {
  return _fontHeight();
 },
 clearClip : function()
 {
  _context.restore();
  _context.save();
 },
 setClip : function( x, y, width, height )
 {
  if( !!_context.clip )
  {
   _context.restore();
   _context.save();
   _context.beginPath();
   _context.moveTo( x, y );
   _context.lineTo( x + width, y );
   _context.lineTo( x + width, y + height );
   _context.lineTo( x, y + height );
   _context.closePath();
   _context.clip();
  }
 },
 drawLine : function( x1, y1, x2, y2 )
 {
  _context.beginPath();
  _context.moveTo( x1 + 0.5, y1 + 0.5 );
  _context.lineTo( x2 + 0.5, y2 + 0.5 );
  _context.stroke();
  _context.closePath();
 },
 drawRect : function( x, y, width, height )
 {
  _context.strokeRect( x + 0.5, y + 0.5, width, height );
 },
 fillRect : function( x, y, width, height )
 {
  _context.fillRect( x, y, width, height );
 },
 drawString : function( str, x, y )
 {
  if( !!_context.fillText )
  {
   _context.fillText( str, x, y );
  }
  else
  {
   if( _USE_DRAWSTRINGEX )
   {
    _drawStringEx( str, x, y );
   }
  }
 },
 setFlipMode : function( flip )
 {
  this.f = flip;
 },
 drawScaledImage : function( image, dx, dy, width, height, sx, sy, swidth, sheight )
 {
  if( this.f == _FLIP_NONE )
  {
   try
   {
    _context.drawImage( image, sx, sy, swidth, sheight, dx, dy, width, height );
   }
   catch( e ){}
  }
  else
  {
   _context.save();
   _context.setTransform( 1.0, 0.0, 0.0, 1.0, 0.0, 0.0 );
   switch( this.f )
   {
   case _FLIP_HORIZONTAL:
    _context.translate( dx + width, dy );
    _context.scale( -1.0, 1.0 );
    break;
   case _FLIP_VERTICAL:
    _context.translate( dx, dy + height );
    _context.scale( 1.0, -1.0 );
    break;
   case _FLIP_ROTATE:
    _context.translate( dx + width, dy + height );
    _context.scale( -1.0, -1.0 );
    break;
   }
   try
   {
    _context.drawImage( image, sx, sy, swidth, sheight, 0, 0, width, height );
   }
   catch( e ){}
   _context.restore();
  }
 },
 drawImage : function( image, x, y )
 {
  this.drawScaledImage( image, x, y, image.width, image.height, 0, 0, image.width, image.height );
 },
 drawTransImage : function( image, dx, dy, sx, sy, width, height, cx, cy, r360, z128x, z128y )
 {
  _context.save();
  _context.setTransform( 1.0, 0.0, 0.0, 1.0, 0.0, 0.0 );
  _context.translate( dx, dy );
  _context.rotate( (Math.PI * r360) / 180 );
  _context.scale( z128x / 128, z128y / 128 );
  _context.translate( -cx, -cy );
  try
  {
   _context.drawImage( image, sx, sy, width, height, 0, 0, width, height );
  }
  catch( e ){}
  _context.restore();
 }
};
function _httpOpen( method, url )
{
 var request = null;
 if( !!XMLHttpRequest )
 {
  request = new XMLHttpRequest();
 }
 else if( !!ActiveXObject )
 {
  try
  {
   request = new ActiveXObject( "Msxml2.XMLHTTP.6.0" );
  }
  catch( e )
  {
   try
   {
    request = new ActiveXObject( "Msxml2.XMLHTTP.3.0" );
   }
   catch( e )
   {
    try
    {
     request = new ActiveXObject( "Msxml2.XMLHTTP" );
    }
    catch( e )
    {
     try
     {
      request = new ActiveXObject( "Microsoft.XMLHTTP" );
     }
     catch( e ){}
    }
   }
  }
 }
 if( request != null )
 {
  request.open( method, url, true );
  request.onreadystatechange = function()
  {
   if( request.readyState == 4 )
   {
    if( request.status == 200 )
    {
     onHttpResponse( request, request.responseText );
    }
    else
    {
     onHttpError( request, request.status );
    }
   }
  };
 }
 return request;
}
function httpGet( url )
{
 var request = _httpOpen( "GET", url );
 if( request != null )
 {
  request.setRequestHeader( "If-Modified-Since", "Thu, 01 Jun 1970 00:00:00 GMT" );
  request.send( null );
 }
 return request;
}
function httpPost( url, data, type )
{
 var request = _httpOpen( "POST", url );
 if( request != null )
 {
  request.setRequestHeader( "If-Modified-Since", "Thu, 01 Jun 1970 00:00:00 GMT" );
  request.setRequestHeader( "Content-Type", type );
  request.send( data );
 }
 return request;
}
var _image_load = 0;
function loadImage( src )
{
 _image_load++;
 var image = new Image();
 image.onload = function()
 {
  _image_load--;
 };
 image.src = src;
 return image;
}
function isImageBusy()
{
 return (_image_load > 0);
}
function _Image( width, height )
{
 this.image = new Image();
 this.canvas = document.createElement( "canvas" );
 this.context = this.canvas.getContext( "2d" );
 this.canvas.width = width;
 this.canvas.height = height;
 this.context.textAlign = "left";
 this.context.textBaseline = "bottom";
}
_Image.prototype = {
 lock : function()
 {
  this.sav_canvas = _canvas;
  this.sav_context = _context;
  this.sav_lock = _lock;
  _canvas = this.canvas;
  _context = this.context;
  _lock = true;
  _context.clearRect( 0, 0, _canvas.width, _canvas.height );
  _context.save();
 },
 unlock : function()
 {
  _context.restore();
  _canvas = this.sav_canvas;
  _context = this.sav_context;
  _lock = this.sav_lock;
  this.image.src = this.canvas.toDataURL();
 },
 getWidth : function()
 {
  return this.canvas.width;
 },
 getHeight : function()
 {
  return this.canvas.height;
 },
 getImage : function()
 {
  return this.image;
 }
};
var _json_str;
function jsonInit()
{
 _json_str = "";
}
function jsonAddInteger( key, value )
{
 if( _json_str.length > 0 )
 {
  _json_str += ',';
 }
 _json_str += "\"" + key + "\":\"" + value + "\"";
}
function jsonAddString( key, value )
{
 if( _json_str.length > 0 )
 {
  _json_str += ',';
 }
 _json_str += "\"" + key + "\":\"" + encodeURIComponent( value ) + "\"";
}
function jsonOut()
{
 return "{" + _json_str + "}";
}
var _json_array;
function jsonResponse( data )
{
 _json_array = eval( "(" + data + ")" );
}
function jsonGetSize()
{
 if( _json_array.length != undefined )
 {
  return _json_array.length;
 }
 return 0;
}
function jsonGetString( index, key, defString )
{
 if( _json_array.length != undefined )
 {
  return decodeURIComponent( (key in _json_array[index]) ? _json_array[index][key] : defString );
 }
 return decodeURIComponent( (key in _json_array) ? _json_array[key] : defString );
}
function jsonGetInteger( index, key, defInteger )
{
 return parseInt( jsonGetString( index, key, "" + defInteger ) );
}
window._USE_AUDIOEX = false;
window._USE_DRAWSTRINGEX = false;
window._USE_EXCANVAS = false;
window._USE_KEY = false;
window._USE_MOUSE = false;
window._USE_TOUCH = false;
window._USE_LAYOUTMOUSE = false;
window._USE_LAYOUTTOUCH = false;
window._USE_REQUESTANIMATIONFRAME = false;
window._KEY_BACKSPACE = 8;
window._KEY_TAB = 9;
window._KEY_ENTER = 13;
window._KEY_SELECT = _KEY_ENTER;
window._KEY_SHIFT = 16;
window._KEY_CTRL = 17;
window._KEY_SPACE = 32;
window._KEY_LEFT = 37;
window._KEY_UP = 38;
window._KEY_RIGHT = 39;
window._KEY_DOWN = 40;
window._KEY_0 = 48;
window._KEY_1 = 49;
window._KEY_2 = 50;
window._KEY_3 = 51;
window._KEY_4 = 52;
window._KEY_5 = 53;
window._KEY_6 = 54;
window._KEY_7 = 55;
window._KEY_8 = 56;
window._KEY_9 = 57;
window._KEY_C = 67;
window._KEY_X = 88;
window._KEY_Z = 90;
window._ROP_COPY = "source-over";
window._ROP_ADD = "lighter";
window._FLIP_NONE = 0;
window._FLIP_HORIZONTAL = 1;
window._FLIP_VERTICAL = 2;
window._FLIP_ROTATE = 3;
window._BUTTON_DOWN_EVENT = 0;
window._BUTTON_OUT_EVENT = 1;
window._BUTTON_OVER_EVENT = 2;
window._BUTTON_UP_EVENT = 3;
window._KEY_PRESSED_EVENT = 4;
window._KEY_RELEASED_EVENT = 5;
window._LAYOUT_DOWN_EVENT = 6;
window._LAYOUT_UP_EVENT = 7;
window._MOUSE_DOWN_EVENT = 8;
window._MOUSE_MOVE_EVENT = 9;
window._MOUSE_OUT_EVENT = 10;
window._MOUSE_OVER_EVENT = 11;
window._MOUSE_UP_EVENT = 12;
window._ORIENTATIONCHANGE_EVENT = 13;
window._RESIZE_EVENT = 14;
window._TOUCH_START_EVENT = 15;
window._TOUCH_MOVE_EVENT = 16;
window._TOUCH_END_EVENT = 17;
var _canvas;
var _context;
var _lock;
var _key = 0;
var _use_layout = false;
var _layout = new Array();
var _mouse_x;
var _mouse_y;
var _touch_start = false;
var _touch_x = new Array();
var _touch_y = new Array();
var _touch_x0;
var _touch_y0;
var _color;
var _font_size;
var _font_family;
var _stringex = new Array();
var _stringex_num;
var _text;
var _text_style = "visibility:hidden;position:absolute;left:0px;top:0px";
function d2js_onload()
{
 init();
 if( _USE_LAYOUTMOUSE )
 {
  _use_layout = true;
  _USE_MOUSE = true;
 }
 if( _USE_LAYOUTTOUCH )
 {
  _use_layout = true;
  _USE_TOUCH = true;
 }
 if( _USE_EXCANVAS || canUseCanvas() )
 {
  _text = document.createElement( "span" );
  _text.style.cssText = _text_style;
  document.body.appendChild( _text );
  if( _USE_KEY )
  {
   _addEventListener( document, "keydown", _onKeyDown );
   _addEventListener( document, "keyup", _onKeyUp );
  }
  if( _USE_TOUCH )
  {
   _addEventListener( document, "touchstart", _onTouchStart );
   _addEventListener( document, "touchmove", _onTouchMove );
   _addEventListener( document, "touchend", _onTouchEnd );
  }
  if( start() )
  {
   _loop();
  }
 }
 else
 {
  error();
 }
}
function d2js_onorientationchange()
{
 processEvent( _ORIENTATIONCHANGE_EVENT, window.orientation );
}
function d2js_onresize()
{
 processEvent( _RESIZE_EVENT, 0 );
}
function d2js_paint()
{
 if( _USE_DRAWSTRINGEX )
 {
  _stringex_num = 0;
 }
 _context.clearRect( 0, 0, getWidth(), getHeight() );
 _context.save();
 paint();
 _context.restore();
 if( _USE_DRAWSTRINGEX )
 {
  for( var i = _stringex_num; i < _stringex.length; i++ )
  {
   _stringex[i].innerHTML = "";
  }
 }
}
function d2js_loop()
{
 _loop();
}
function canUseCanvas()
{
 return (!!document.createElement( "canvas" ).getContext);
}
function getCurrent()
{
 return _canvas;
}
function getCurrentContext()
{
 return _context;
}
function getWidth()
{
 return parseInt( _canvas.width );
}
function getHeight()
{
 return parseInt( _canvas.height );
}
function getKeypadState()
{
 return _key;
}
function getMouseX()
{
 return _mouse_x;
}
function getMouseY()
{
 return _mouse_y;
}
function touchNum()
{
 return _touch_x.length;
}
function getTouchX( index )
{
 return ((index < _touch_x.length) ? _touch_x[index] : _touch_x0);
}
function getTouchY( index )
{
 return ((index < _touch_y.length) ? _touch_y[index] : _touch_y0);
}
function getResImage( id )
{
 return document.getElementById( id );
}
function getResString( id )
{
 var str = document.getElementById( id ).innerHTML;
 str = str.replace( /&lt;/igm, "<" );
 str = str.replace( /&gt;/igm, ">" );
 return str;
}
function currentTimeMillis()
{
 return (new Date()).getTime();
}
function _getLeft( e )
{
 var left = 0;
 while( e )
 {
  left += e.offsetLeft;
  e = e.offsetParent;
 }
 return left;
}
function _getTop( e )
{
 var top = 0;
 while( e )
 {
  top += e.offsetTop;
  e = e.offsetParent;
 }
 return top;
}
function getBrowserWidth()
{
 if( (!!document.documentElement) && (document.documentElement.clientWidth > 0) )
 {
  return document.documentElement.clientWidth;
 }
 else if( !!document.body )
 {
  return document.body.clientWidth;
 }
 else if( !!window.innerWidth )
 {
  return window.innerWidth;
 }
 return 0;
}
function getBrowserHeight()
{
 if( (!!document.documentElement) && (document.documentElement.clientHeight > 0) )
 {
  return document.documentElement.clientHeight;
 }
 else if( !!document.body )
 {
  return document.body.clientHeight;
 }
 else if( !!window.innerHeight )
 {
  return window.innerHeight;
 }
 return 0;
}
function getOrientation()
{
 return window.orientation;
}
function setCanvasSize( _width, _height )
{
 _canvas.width = _width;
 _canvas.height = _height;
 _context.textAlign = "left";
 _context.textBaseline = "bottom";
}
var _start_time;
var _end_time;
var _sleep_time;
function _getSleepTime()
{
 _sleep_time = frameTime() - (_end_time - _start_time);
 if( _sleep_time < 0 )
 {
  _sleep_time = 0;
 }
 if( _sleep_time > frameTime() )
 {
  _sleep_time = frameTime();
 }
}
function _sleep()
{
 while( (_end_time > _start_time) && ((_end_time - _start_time) < frameTime()) )
 {
  _end_time = currentTimeMillis();
 }
}
function _loop()
{
 _start_time = currentTimeMillis();
 d2js_paint();
 _end_time = currentTimeMillis();
 if( _USE_REQUESTANIMATIONFRAME )
 {
  if( !!window.requestAnimationFrame )
  {
   _sleep();
   window.requestAnimationFrame( _loop );
  }
  else if( !!window.webkitRequestAnimationFrame )
  {
   _sleep();
   window.webkitRequestAnimationFrame( _loop );
  }
  else if( !!window.mozRequestAnimationFrame )
  {
   _sleep();
   window.mozRequestAnimationFrame( _loop );
  }
  else if( !!window.oRequestAnimationFrame )
  {
   _sleep();
   window.oRequestAnimationFrame( _loop );
  }
  else if( !!window.msRequestAnimationFrame )
  {
   _sleep();
   window.msRequestAnimationFrame( _loop );
  }
  else
  {
   _getSleepTime();
   window.setTimeout( _loop, _sleep_time );
  }
 }
 else
 {
  _getSleepTime();
  window.setTimeout( _loop, _sleep_time );
 }
}
function _addEventListener( target, event, func )
{
 if( !!target.addEventListener )
 {
  target.addEventListener( event, func, false );
 }
 else if( !!target.attachEvent )
 {
  target.attachEvent( "on" + event, func );
 }
 else
 {
  target["on" + event] = func;
 }
}
function _removeEventListener( target, event, func )
{
 if( !!target.removeEventListener )
 {
  target.removeEventListener( event, func, false );
 }
 else if( !!target.detachEvent )
 {
  target.detachEvent( "on" + event, func );
 }
 else
 {
  target["on" + event] = null;
 }
}
function setCurrent( id )
{
 _canvas = document.getElementById( id );
 _context = _canvas.getContext( "2d" );
 _lock = false;
 _context.textAlign = "left";
 _context.textBaseline = "bottom";
 if( _USE_MOUSE )
 {
  _addEventListener( _canvas, "mousedown", _onMouseDown );
  _addEventListener( _canvas, "mousemove", _onMouseMove );
  _addEventListener( _canvas, "mouseout", _onMouseOut );
  _addEventListener( _canvas, "mouseover", _onMouseOver );
  _addEventListener( _canvas, "mouseup", _onMouseUp );
 }
}
function readParameter( text, key )
{
 var ret = "";
 var start = text.indexOf( key + "=" );
 if( start >= 0 )
 {
  start += key.length + 1;
  var end = text.indexOf( "&", start );
  if( end < 0 )
  {
   end = text.length;
  }
  ret = text.substring( start, end );
 }
 return decodeURIComponent( ret );
}
function readParameters( text )
{
 var params = text.split( "&" );
 var key = new Array();
 for( var i = 0; i < params.length; i++ )
 {
  var param = params[i].split( "=" );
  key[param[0]] = decodeURIComponent( param[1] );
 }
 return key;
}
function getParameter( key )
{
 return readParameter( location.href, key );
}
function keyBit( key )
{
 var bit;
 switch( key )
 {
 case _KEY_BACKSPACE: bit = 0; break;
 case _KEY_TAB: bit = 1; break;
 case _KEY_ENTER: bit = 2; break;
 case _KEY_SHIFT: bit = 3; break;
 case _KEY_CTRL: bit = 4; break;
 case _KEY_SPACE: bit = 5; break;
 case _KEY_LEFT: bit = 6; break;
 case _KEY_UP: bit = 7; break;
 case _KEY_RIGHT: bit = 8; break;
 case _KEY_DOWN: bit = 9; break;
 case _KEY_0: bit = 10; break;
 case _KEY_1: bit = 11; break;
 case _KEY_2: bit = 12; break;
 case _KEY_3: bit = 13; break;
 case _KEY_4: bit = 14; break;
 case _KEY_5: bit = 15; break;
 case _KEY_6: bit = 16; break;
 case _KEY_7: bit = 17; break;
 case _KEY_8: bit = 18; break;
 case _KEY_9: bit = 19; break;
 case _KEY_C: bit = 20; break;
 case _KEY_X: bit = 21; break;
 case _KEY_Z: bit = 22; break;
 default:
  return 0;
 }
 return (1 << bit);
}
function _onKeyDown( e )
{
 var k = keyBit( e.keyCode );
 if( (_key & k) == 0 )
 {
  _key += k;
 }
 processEvent( _KEY_PRESSED_EVENT, e.keyCode );
}
function _onKeyUp( e )
{
 var k = keyBit( e.keyCode );
 if( (_key & k) != 0 )
 {
  _key -= k;
 }
 processEvent( _KEY_RELEASED_EVENT, e.keyCode );
}
function __MainLayout( x, y, width, height, id )
{
 this.x = x;
 this.y = y;
 this.width = width;
 this.height = height;
 this.id = id;
 this.shape = null;
 this.coords = null;
}
function clearLayout()
{
 _layout = new Array();
}
function addLayout( x, y, w, h, id )
{
 _layout[_layout.length] = new __MainLayout( x, y, w, h, id );
}
function addLayoutArea( x, y, width, height, id, shape, coords )
{
 addLayout( x, y, width, height, id );
 if( !!_context.isPointInPath )
 {
  _layout[_layout.length - 1].shape = shape;
  var tmp = coords.split( "," );
  _layout[_layout.length - 1].coords = new Array( tmp.length );
  for( var i = 0; i < tmp.length; i++ )
  {
   _layout[_layout.length - 1].coords[i] = parseInt( tmp[i] );
  }
 }
}
function getLayout( id )
{
 if( _layout.length > 0 )
 {
  for( var i = 0; i < _layout.length; i++ )
  {
   if( _layout[i].id == id )
   {
    return _layout[i];
   }
  }
 }
 return null;
}
function checkLayout( x, y )
{
 if( _layout.length > 0 )
 {
  for( var i = 0; i < _layout.length; i++ )
  {
   if( _layout[i].shape == null )
   {
    if( (x >= _layout[i].x) &&
     (x < _layout[i].x + _layout[i].width) &&
     (y >= _layout[i].y) &&
     (y < _layout[i].y + _layout[i].height) )
    {
     return _layout[i].id;
    }
   }
   else
   {
    _context.beginPath();
    if( _layout[i].shape == "circle" )
    {
     _context.arc(
      _layout[i].x + _layout[i].coords[0],
      _layout[i].y + _layout[i].coords[1],
      _layout[i].coords[2],
      0.0, Math.PI * 2.0, false
      );
    }
    else if( _layout[i].shape == "poly" )
    {
     _context.moveTo(
      _layout[i].x + _layout[i].coords[0],
      _layout[i].y + _layout[i].coords[1]
      );
     for( var j = 2; j < _layout[i].coords.length - 1; j += 2 )
     {
      _context.lineTo(
       _layout[i].x + _layout[i].coords[j],
       _layout[i].y + _layout[i].coords[j + 1]
       );
     }
     _context.closePath();
    }
    else if( _layout[i].shape == "rect" )
    {
     _context.moveTo( _layout[i].x + _layout[i].coords[0], _layout[i].y + _layout[i].coords[1] );
     _context.lineTo( _layout[i].x + _layout[i].coords[2], _layout[i].y + _layout[i].coords[1] );
     _context.lineTo( _layout[i].x + _layout[i].coords[2], _layout[i].y + _layout[i].coords[3] );
     _context.lineTo( _layout[i].x + _layout[i].coords[0], _layout[i].y + _layout[i].coords[3] );
     _context.closePath();
    }
    if( _context.isPointInPath( x, y ) )
    {
     return _layout[i].id;
    }
   }
  }
 }
 return -1;
}
function _getMouse( e )
{
 _mouse_x = e.clientX + document.body.scrollLeft + document.documentElement.scrollLeft - _getLeft( _canvas );
 _mouse_y = e.clientY + document.body.scrollTop + document.documentElement.scrollTop - _getTop( _canvas );
}
function _onMouseDown( e )
{
 _getMouse( e );
 if( _use_layout )
 {
  if( _layout.length > 0 )
  {
   var p = checkLayout( _mouse_x, _mouse_y );
   if( p >= 0 )
   {
    processEvent( _LAYOUT_DOWN_EVENT, p );
    return;
   }
  }
 }
 processEvent( _MOUSE_DOWN_EVENT, 0 );
}
function _onMouseMove( e )
{
 _getMouse( e );
 processEvent( _MOUSE_MOVE_EVENT, 0 );
}
function _onMouseOut( e )
{
 _getMouse( e );
 processEvent( _MOUSE_OUT_EVENT, 0 );
}
function _onMouseOver( e )
{
 _getMouse( e );
 processEvent( _MOUSE_OVER_EVENT, 0 );
}
function _onMouseUp( e )
{
 _getMouse( e );
 if( _use_layout )
 {
  if( _layout.length > 0 )
  {
   var p = checkLayout( _mouse_x, _mouse_y );
   if( p >= 0 )
   {
    processEvent( _LAYOUT_UP_EVENT, p );
    return;
   }
  }
 }
 processEvent( _MOUSE_UP_EVENT, 0 );
}
function _getTouch( e )
{
 _touch_x = new Array();
 _touch_y = new Array();
 for( var i = 0; i < e.touches.length; i++ )
 {
  _touch_x[i] = e.touches[i].pageX - _getLeft( _canvas );
  _touch_y[i] = e.touches[i].pageY - _getTop( _canvas );
 }
}
function _onTouchStart( e )
{
 _getTouch( e );
 _touch_x0 = _touch_x[0];
 _touch_y0 = _touch_y[0];
 if( (_touch_x0 >= 0) && (_touch_x0 < getWidth()) && (_touch_y0 >= 0) && (_touch_y0 < getHeight()) )
 {
  _touch_start = true;
  if( _use_layout )
  {
   if( _layout.length > 0 )
   {
    var p = checkLayout( _touch_x0, _touch_y0 );
    if( p >= 0 )
    {
     processEvent( _LAYOUT_DOWN_EVENT, p );
     e.preventDefault();
     return;
    }
   }
  }
  processEvent( _TOUCH_START_EVENT, 0 );
  e.preventDefault();
 }
}
function _onTouchMove( e )
{
 if( _touch_start )
 {
  _getTouch( e );
  _touch_x0 = _touch_x[0];
  _touch_y0 = _touch_y[0];
  processEvent( _TOUCH_MOVE_EVENT, 0 );
  e.preventDefault();
 }
}
function _onTouchEnd( e )
{
 if( _touch_start )
 {
  _touch_start = false;
  _getTouch( e );
  if( _use_layout )
  {
   if( _layout.length > 0 )
   {
    var p = checkLayout( _touch_x0, _touch_y0 );
    if( p >= 0 )
    {
     processEvent( _LAYOUT_UP_EVENT, p );
     e.preventDefault();
     return;
    }
   }
  }
  processEvent( _TOUCH_END_EVENT, 0 );
  e.preventDefault();
 }
}
function getLayoutState()
{
 var ret = 0;
 var id;
 for( var i = 0; i < _touch_x.length; i++ )
 {
  id = checkLayout( _touch_x[i], _touch_y[i] );
  if( id >= 0 )
  {
   ret |= (1 << id);
  }
 }
 return ret;
}
function layoutBit( id )
{
 return (1 << id);
}
function launch( url )
{
 location.replace( url );
}
function _stringWidth( str )
{
 _text.innerHTML = "'";
 var tmp = _text.offsetWidth;
 str = str.replace( /</igm, "&lt;" );
 str = str.replace( />/igm, "&gt;" );
 _text.innerHTML = "'" + str + "'";
 return _text.offsetWidth - tmp * 2;
}
function _fontHeight()
{
 return _font_size;
}
function _drawStringEx( str, x, y )
{
 if( _lock )
 {
  return;
 }
 if( _stringex_num >= _stringex.length )
 {
  _stringex[_stringex_num] = document.createElement( "span" );
  _stringex[_stringex_num].style.cssText = "position:absolute";
  document.body.appendChild( _stringex[_stringex_num] );
  if( _USE_MOUSE )
  {
   _addEventListener( _stringex[_stringex_num], "mousedown", _onMouseDown );
   _addEventListener( _stringex[_stringex_num], "mousemove", _onMouseMove );
   _addEventListener( _stringex[_stringex_num], "mouseup", _onMouseUp );
  }
 }
 _stringex[_stringex_num].style.cssText = "position:absolute;left:" + (_getLeft( _canvas ) + x) + "px;top:" + (_getTop( _canvas ) + y - _font_size) + "px;color:" + _color + ";font:" + _font_size + "px " + _font_family;
 str = str.replace( /</igm, "&lt;" );
 str = str.replace( />/igm, "&gt;" );
 _stringex[_stringex_num].innerHTML = str;
 _stringex_num++;
}
var g;
var img;
var str;
var http_request_1;
var http_request_2;
var http_request_3;
function frameTime(){ return 1000 / 60 ; }
function init()
{
}
function start()
{
 var i, j;
 setCurrent( "canvas0" );
 g = new _Graphics();
 for( i = 0; i < 3; i++ )
 {
  switch( i )
  {
  case 0: id = "get" ; break;
  case 1: id = "post"; break;
  case 2: id = "json"; break;
  }
  for( j = 0; j < 4; j++ )
  {
   addEventListener( document.getElementById( id + j ), "mousedown", imgMouseDown );
   addEventListener( document.getElementById( id + j ), "mouseup" , imgMouseUp );
   addEventListener( document.getElementById( id + j ), "mouseover", imgMouseOver );
   addEventListener( document.getElementById( id + j ), "mouseout" , imgMouseOut );
  }
 }
 img = loadImage( "error.jpg" );
 str = new Array( 5 );
 for( i = 0; i < 5; i++ )
 {
  str[i] = "";
 }
 http_request_1 = null;
 http_request_2 = null;
 http_request_3 = null;
 return true;
}
function imgMouseDown( e )
{
 str[0] = e.target.id + " MOUSE DOWN";
 if( (http_request_1 != null) ||
  (http_request_2 != null) ||
  (http_request_3 != null) )
 {
  return;
 }
 var character = "ダミー";
 if( (e.target.id === "get0") || (e.target.id === "post0") || (e.target.id === "json0") )
 {
  character = "こむ";
 }
 if( (e.target.id === "get1") || (e.target.id === "post1") || (e.target.id === "json1") )
 {
  character = "ラクス";
 }
 if( (e.target.id === "get2") || (e.target.id === "post2") || (e.target.id === "json2") )
 {
  character = "レイ";
 }
 if( (e.target.id === "get0") || (e.target.id === "get1") || (e.target.id === "get2") || (e.target.id === "get3") )
 {
  str[1] = SERVER + "test1.php?character=" + encodeURIComponent( character );
  http_request_1 = httpGet( str[1] );
 }
 if( (e.target.id === "post0") || (e.target.id === "post1") || (e.target.id === "post2") || (e.target.id === "post3") )
 {
  str[1] = "character=" + encodeURIComponent( character );
  http_request_2 = httpPost( SERVER + "test2.php", str[1], "application/x-www-form-urlencoded" );
 }
 if( (e.target.id === "json0") || (e.target.id === "json1") || (e.target.id === "json2") || (e.target.id === "json3") )
 {
  jsonInit();
  jsonAddString( "character", character );
  str[1] = jsonOut();
  http_request_3 = httpPost( SERVER + "test3.php", str[1], "application/json" );
 }
}
function imgMouseUp( e )
{
 str[0] = e.target.id + " MOUSE UP";
}
function imgMouseOver( e )
{
 str[0] = e.target.id + " MOUSE OVER";
}
function imgMouseOut( e )
{
 str[0] = e.target.id + " MOUSE OUT";
}
function onHttpResponse( request, data )
{
 str[2] = data;
 if( request == http_request_1 )
 {
  str[3] = readParameter( data, "character" );
  str[4] = readParameter( data, "image" );
  img.src = SERVER + str[4];
  http_request_1 = null;
 }
 if( request == http_request_2 )
 {
  var key = readParameters( data );
  str[3] = ("character" in key) ? key["character"] : "";
  str[4] = ("image" in key) ? key["image"] : "";
  img.src = SERVER + str[4];
  http_request_2 = null;
 }
 if( request == http_request_3 )
 {
  jsonResponse( data );
  str[3] = jsonGetString( 0, "character", "" );
  str[4] = jsonGetString( 0, "image", "" );
  img.src = SERVER + str[4];
  http_request_3 = null;
 }
}
function onHttpError( request, status )
{
 str[2] = "通信エラー " + status;
 if( request == http_request_1 )
 {
  http_request_1 = null;
 }
 if( request == http_request_2 )
 {
  http_request_2 = null;
 }
 if( request == http_request_3 )
 {
  http_request_3 = null;
 }
}
function paint()
{
 g.setColor( g.getColorOfRGB( 127, 127, 127 ) );
 g.fillRect( 0, 0, getWidth(), getHeight() );
 g.drawScaledImage( img, 160, 0, 480, 480, 0, 0, img.width, img.height );
 g.setColor( g.getColorOfRGB( 0, 255, 255 ) );
 g.setFont( 18, "ＭＳ ゴシック" );
 if( (http_request_1 != null) ||
  (http_request_2 != null) ||
  (http_request_3 != null) )
 {
  str[2] = "通信中...";
 }
 for( var i = 0; i < 5; i++ )
 {
  g.drawString( str[i], 0, g.fontHeight() + g.fontHeight() * i );
 }
}
function processEvent( type, param )
{
}
function error()
{
 launch( "error.html" );
}
