/*
 * D2JS
 * Copyright (C) SatisKia. All rights reserved.
 */
function canUseCookie()
{
	return navigator.cookieEnabled;
}
var _cookie_expires = "Tue, 1-Jan-2030 00:00:00 GMT";
function setExpiresDate( date )
{
	_cookie_expires = (new Date( currentTimeMillis() + date * 86400000 )).toGMTString();
}
function getCookie( key, defValue )
{
	var cookie = document.cookie.split( "; " );
	for( var i = 0; i < cookie.length; i++ )
	{
		var param = cookie[i].split( "=" );
		if( param[0] == key )
		{
			return unescape( param[1] );
		}
	}
	return defValue;
}
function setCookie( key, value )
{
	document.cookie = key + "=" + escape( value ) + "; expires=" + _cookie_expires;
}
var _cookie_val;
var _cookie_s;
var _cookie_str;
function beginCookieRead( key )
{
	_cookie_val = getCookie( key, "" );
	_cookie_s = 0;
}
function cookieRead()
{
	if( _cookie_s >= _cookie_val.length )
	{
		_cookie_str = "";
	}
	else
	{
		var e = _cookie_val.indexOf( "&", _cookie_s );
		if( e < 0 )
		{
			e = _cookie_val.length;
		}
		_cookie_str = _cookie_val.substring( _cookie_s, e );
		_cookie_s = e + 1;
	}
	return unescape( _cookie_str );
}
function endCookieRead()
{
	_cookie_val = "";
	_cookie_str = "";
}
function beginCookieWrite()
{
	_cookie_val = "";
}
function cookieWrite( str )
{
	if( _cookie_val.length > 0 )
	{
		_cookie_val += "&";
	}
	_cookie_val += escape( str );
}
function endCookieWrite( key )
{
	setCookie( key, _cookie_val );
	_cookie_val = "";
}
