/*
 * D2JS
 * Copyright (C) SatisKia. All rights reserved.
 */
function canUseAudio()
{
	return (!!document.createElement( "audio" ).canPlayType);
}
function canPlayType( type )
{
	if( canUseAudio() )
	{
		var audio = document.createElement( "audio" );
		return (audio.canPlayType( type ) != "no") && (audio.canPlayType( type ) != "");
	}
	return false;
}
function __Audio()
{
	this.element = null;
	this.state = 0;
}
function __AudioEx()
{
	this.element = null;
	this.src = null;
	this.tag = null;
}
function _useAudioEx()
{
	if( _USE_AUDIOEX )
	{
		if( !canUseAudio() )
		{
			return true;
		}
	}
	return false;
}
function loadAudio( src )
{
	if( _useAudioEx() )
	{
		return loadAudioEx( src );
	}
	try
	{
		var audio = new __Audio();
		audio.element = new Audio( "" );
		audio.element.autoplay = false;
		audio.element.src = src;
		audio.element.load();
		return audio;
	}
	catch( e ){}
	return null;
}
function loadAudioEx( src )
{
	var audio = new __AudioEx();
	audio.src = src;
	return audio;
}
function loadAndPlayAudio( src, loop )
{
	if( _useAudioEx() )
	{
		return loadAndPlayAudioEx( src, loop, audioExElement() );
	}
	try
	{
		var audio = new __Audio();
		audio.element = new Audio( "" );
		audio.element.autoplay = false;
		audio.element.src = src;
		audio.element.loop = loop;
		audio.element.play();
		audio.state = 1;
		return audio;
	}
	catch( e ){}
	return null;
}
function loadAndPlayAudioEx( src, loop, tag )
{
	var audio = loadAudioEx( src );
	playAudioEx( audio, loop, tag );
	return audio;
}
function isLoaded( audio )
{
	if( _useAudioEx() )
	{
		return true;
	}
	if( audio != null )
	{
		try
		{
			if( audio.element.readyState >= 4 )
			{
				return true;
			}
		}
		catch( e ){}
	}
	return false;
}
function stopAudio( audio )
{
	if( _useAudioEx() )
	{
		stopAudioEx( audio );
		return;
	}
	if( audio != null )
	{
		try
		{
			if( audio.state == 2 )
			{
				audio.element.currentTime = 0;
			}
			if( (audio.state == 1) && !audio.element.ended )
			{
				audio.element.pause();
				audio.element.currentTime = 0;
			}
		}
		catch( e ){}
		audio.state = 0;
	}
}
function stopAudioEx( audio )
{
	if( (audio != null) && (audio.element != null) )
	{
		audio.element.setAttribute( "src", "" );
		document.body.removeChild( audio.element );
		audio.element = null;
	}
}
function reloadAudio( audio )
{
	stopAudio( audio );
	if( _useAudioEx() )
	{
		return;
	}
	if( audio != null )
	{
		try
		{
			audio.element.load();
		}
		catch( e ){}
	}
}
function playAudio( audio, loop )
{
	if( _useAudioEx() )
	{
		playAudioEx( audio, loop, audioExElement() );
		return;
	}
	if( audio != null )
	{
		try
		{
			if( (audio.state == 1) && !audio.element.ended )
			{
				audio.element.pause();
				audio.element.currentTime = 0;
			}
		}
		catch( e ){}
		try
		{
			audio.element.loop = loop;
			audio.element.play();
			audio.state = 1;
		}
		catch( e ){}
	}
}
function playAudioEx( audio, loop, tag )
{
	if( audio != null )
	{
		if( audio.element != null )
		{
			audio.element.setAttribute( "src", "" );
			document.body.removeChild( audio.element );
		}
		audio.tag = tag;
		audio.element = document.createElement( audio.tag );
		audio.element.setAttribute( "src", audio.src );
		if( audio.tag == "audio" )
		{
			audio.element.setAttribute( "autoplay", "true" );
			if( loop )
			{
				audio.element.setAttribute( "loop", "true" );
			}
		}
		else if( audio.tag == "bgsound" )
		{
			if( loop )
			{
				audio.element.setAttribute( "loop", "infinite" );
			}
		}
		else if( audio.tag == "embed" )
		{
			audio.element.setAttribute( "autostart", "true" );
			audio.element.setAttribute( "hidden", "false" );
			audio.element.setAttribute( "width", "1" );
			audio.element.setAttribute( "height", "1" );
			if( loop )
			{
				audio.element.setAttribute( "loop", "true" );
				audio.element.setAttribute( "repeat", "true" );
			}
		}
		document.body.appendChild( audio.element );
	}
}
function isPlaying( audio )
{
	if( _useAudioEx() )
	{
		return isPlayingEx( audio );
	}
	if( (audio != null) && (audio.state == 1) )
	{
		try
		{
			return !audio.element.ended;
		}
		catch( e ){}
		return true;
	}
	return false;
}
function isPlayingEx( audio )
{
	if( (audio != null) && (audio.element != null) )
	{
		if( audio.tag == "audio" )
		{
			try
			{
				return !audio.element.ended;
			}
			catch( e ){}
		}
		return true;
	}
	return false;
}
function pauseAudio( audio )
{
	if( _useAudioEx() )
	{
		return;
	}
	if( audio != null )
	{
		try
		{
			if( (audio.state == 1) && !audio.element.ended )
			{
				audio.element.pause();
			}
		}
		catch( e ){}
		audio.state = 2;
	}
}
function restartAudio( audio )
{
	if( _useAudioEx() )
	{
		return;
	}
	if( audio != null )
	{
		try
		{
			if( audio.state == 2 )
			{
				audio.element.play();
				audio.state = 1;
			}
		}
		catch( e ){}
	}
}
function getCurrentTime( audio )
{
	if( _useAudioEx() )
	{
		return 0;
	}
	if( audio != null )
	{
		try
		{
			return Math.floor( audio.element.currentTime * 1000.0 );
		}
		catch( e ){}
	}
	return 0;
}
