#import "MyCanvas.h"

#import "_GLGraphics.h"
#import "_Main.h"
#import "MyGLTexture.h"

@implementation MyCanvas

- (int)_frameTime { return 16/*1000 / 60*/; }

- (void)renderInit
{
//	glDisable( GL_DITHER );	// ディザ処理を無効化し、なめらかな表示に

//	glHint( GL_PERSPECTIVE_CORRECTION_HINT, GL_FASTEST );	// GL_FASTEST or GL_NICEST

//	glShadeModel( GL_SMOOTH );	// GL_FLAT or GL_SMOOTH

	int width;
	int height;
	if( [[self getMain] applyScale] )
	{
		width  = [self getWidth] * [UIScreen mainScreen].scale;
		height = [self getHeight] * [UIScreen mainScreen].scale;
	}
	else
	{
		width  = [self getWidth];
		height = [self getHeight];
	}
	glViewport( 0, 0, width, height );

	glMatrixMode( GL_PROJECTION );
	glLoadIdentity();
	glOrthof( 0, width, 0, height, -1, 1 );

	glMatrixMode( GL_MODELVIEW );
}

- (void)_init3D
{
	glt = [[MyGLTexture alloc] initWithNum:256 :1];
	[glt setCanvasHeight:[self getHeight]];
	[glt use:0];

	g = [[_GLGraphics alloc] initWithTexture:glt];
	[g setSize:[self getWidth] :[self getHeight]];

	[self renderInit];

	step = 0;
	x = 0;
	y = 0;
	angle = 0;
}

- (void)_reset3D
{
	[glt reset];

	[self renderInit];
}

- (void)_end3D
{
	[glt release];

	[g release];
}

- (void)_paint3D:(_Graphics*)_g
{
	switch( step )
	{
	case 0:
		x++; if( x >= 60 ) step++;
		break;
	case 1:
		y++; if( y >= 60 ) step++;
		break;
	case 2:
		x--; if( x <= 0 ) step++;
		break;
	case 3:
		y--; if( y <= 0 ) step = 0;
		break;
	}

	[self lock3D];

	glClearColor( 0.5f, 0.5f, 1.0f, 1.0f );
	glClear( GL_COLOR_BUFFER_BIT );

	[glt draw:0 :0 :0 :75 :75 :x :y :120 :120];
	[glt setFlipMode:FLIP_HORIZONTAL];
	[glt draw:0 :90 :0 :75 :75 :x :y :120 :120];
	[glt setFlipMode:FLIP_VERTICAL];
	[glt draw:0 :180 :0 :75 :75 :x :y :120 :120];
	[glt setFlipMode:FLIP_ROTATE];
	[glt draw:0 :270 :0 :75 :75 :x :y :120 :120];
	[glt setFlipMode:FLIP_NONE];

	// 描画の際の座標点指定のテスト
//	[g setOrigin:10 :20];

	[g setAlpha:192];

	[g setColor:[_GLGraphics getColorOfRGB:0 :255 :0]];
	[g fillRect:120 :120 :150 :150];
	[g setColor:[_GLGraphics getColorOfRGB:0 :0 :255]];
	[g fillRect:180 :180 :150 :150];
	[g setColor:[_GLGraphics getColorOfRGB:255 :0 :0]];
	[g fillRect:60 :60 :150 :150];

	[g setColor:[_GLGraphics getColorOfRGB:255 :255 :0]];
	[g setLineWidth:5];
	[g setAlpha:64];
	[g drawLine:60 :60 :209 :209];
	[g drawRect:61 :61 :150 :150];
	[g setLineWidth:1];
	[g setAlpha:255];
	[g drawLine:60 :60 :209 :209];
	[g drawRect:61 :61 :150 :150];
	[g setAlpha:192];

	[g drawScaledTexture:0 :0 :90 :75 :75 :x :y :120 :120];
	[g setFlipMode:FLIP_HORIZONTAL];
	[g drawScaledTexture:0 :90 :90 :75 :75 :x :y :120 :120];
	[g setFlipMode:FLIP_VERTICAL];
	[g drawScaledTexture:0 :180 :90 :75 :75 :x :y :120 :120];
	[g setFlipMode:FLIP_ROTATE];
	[g drawScaledTexture:0 :270 :90 :75 :75 :x :y :120 :120];
	[g setFlipMode:FLIP_NONE];

	[g drawTransTexture:0 :0 :240 :x :y :120 :120 :0 :120 :45.0f :100.0f :100.0f];
	[g setFlipMode:FLIP_HORIZONTAL];
	[g drawTransTexture:0 :90 :240 :x :y :120 :120 :0 :120 :45.0f :100.0f :100.0f];
	[g setFlipMode:FLIP_VERTICAL];
	[g drawTransTexture:0 :180 :240 :x :y :120 :120 :0 :120 :45.0f :100.0f :100.0f];
	[g setFlipMode:FLIP_ROTATE];
	[g drawTransTexture:0 :270 :240 :x :y :120 :120 :0 :120 :45.0f :100.0f :100.0f];
	[g setFlipMode:FLIP_NONE];

	[g drawLine:0 :240 :[self getWidth] :240];

	[g drawTransTexture:0 :45 :390 :x :y :120 :120 :60 :60 :(float)angle :150.0f :100.0f];
	[g drawTransTexture:0 :135 :390 :x :y :120 :120 :60 :60 :(float)angle :-100.0f :150.0f];
	[g drawTransTexture:0 :225 :390 :x :y :120 :120 :60 :60 :(float)angle :150.0f :-100.0f];
	[g drawTransTexture:0 :315 :390 :x :y :120 :120 :60 :60 :(float)angle :-100.0f :-150.0f];
	angle++;

	[g drawLine:0 :390 :[self getWidth] :390];

	[g setAlpha:255];

	[self unlock3D];
}

@end
