/*
 * D2iP
 * Copyright (C) SatisKia. All rights reserved.
 */

#import "_WebView.h"

#import "_Main.h"

@implementation _WebView

- (id)initWithMain:(_Main*)m
{
	self = [super init];
	if( self != nil )
	{
		_m = m;

		_web_view = [[UIWebView alloc] init];
		_web_view.delegate = self;

		_cache = YES;
		_timeout = 60.0f;

		_load_count = 0;
	}
	return self;
}

- (void)dealloc
{
	_web_view.delegate = nil;
	if( [_web_view isLoading] )
	{
		[_web_view stopLoading];
	}
	[_web_view release];

	[super dealloc];
}

- (UIWebView*)getView
{
	return _web_view;
}

- (void)setCache:(BOOL)cache
{
	_cache = cache;
}

- (void)setTimeout:(float)timeout
{
	_timeout = timeout;
}

- (void)setAutoresizingMask:(UIViewAutoresizing)autoresizingMask
{
	_web_view.autoresizingMask = autoresizingMask;
}
- (void)setBackgroundColor:(UIColor*)color
{
	_web_view.backgroundColor = color;
}
- (void)setFrame:(CGRect)frame
{
	_web_view.frame = frame;
}
- (void)setOpaque:(BOOL)opaque
{
	_web_view.opaque = opaque;
}
- (void)setScalesPageToFit:(BOOL)scalesPageToFit
{
	_web_view.scalesPageToFit = scalesPageToFit;
}

- (NSString*)getUserAgentString
{
	return [_web_view stringByEvaluatingJavaScriptFromString:@"navigator.userAgent"];
}

- (void)clearCache
{
	[[NSURLCache sharedURLCache] removeAllCachedResponses];
}

- (void)loadURL:(NSString*)url
{
	[_web_view loadRequest:[NSURLRequest
		requestWithURL:[NSURL URLWithString:url]
		cachePolicy:(_cache ? NSURLRequestUseProtocolCachePolicy : NSURLRequestReloadIgnoringLocalCacheData)
		timeoutInterval:_timeout
		]];
}

- (void)loadResource:(NSString*)name
{
	NSString* path = [[NSBundle mainBundle] pathForResource:name ofType:@""];
	if( path != nil )
	{
		[_web_view loadRequest:[NSURLRequest requestWithURL:[NSURL fileURLWithPath:path]]];
	}
}

- (void)callScript:(NSString*)script
{
	[_web_view stringByEvaluatingJavaScriptFromString:script];
}

/*
 * 新しい URL が指定されたときの処理
 */
- (BOOL)webView:(UIWebView*)webView shouldStartLoadWithRequest:(NSURLRequest*)request navigationType:(UIWebViewNavigationType)navigationType
{
	NSString* url = [[request URL] absoluteString];
	if( [url isEqualToString:[[request mainDocumentURL] absoluteString]] )
	{
		if( [_m _onWebViewShouldStartLoad:url] )
		{
			return NO;
		}
		if( [_m getCurrent] != nil )
		{
			if( [[_m getCurrent] _onWebViewShouldStartLoad:url] )
			{
				return NO;
			}
		}

		[_m _onWebViewStartLoad:url];
		if( [_m getCurrent] != nil )
		{
			[[_m getCurrent] _onWebViewStartLoad:url];
		}
	}

	return YES;
}

/*
 * ページ読み込み開始時の処理
 */
- (void)webViewDidStartLoad:(UIWebView*)webView
{
	_load_count++;
}

/*
 * ページ読み込み完了時の処理
 */
- (void)webViewDidFinishLoad:(UIWebView*)webView
{
	if( _load_count > 0 )
	{
		_load_count--;
		if( _load_count == 0 )
		{
			[_m _onWebViewFinishLoad:self];
			if( [_m getCurrent] != nil )
			{
				[[_m getCurrent] _onWebViewFinishLoad:self];
			}
		}
	}
}

/*
 * ページ読み込みエラー時の処理
 */
- (void)webView:(UIWebView*)webView didFailLoadWithError:(NSError*)error
{
	if( _load_count > 0 )
	{
		_load_count--;
	}

	[_m _onWebViewLoadError:error :self];
	if( [_m getCurrent] != nil )
	{
		[[_m getCurrent] _onWebViewLoadError:error :self];
	}
}

- (NSString*)getTitle
{
	return [_web_view stringByEvaluatingJavaScriptFromString:@"document.title"];
}

- (NSString*)getURL
{
	return [_web_view stringByEvaluatingJavaScriptFromString:@"document.URL"];
}

- (BOOL)canGoForward
{
	return [_web_view canGoForward];
}

- (void)goForward
{
	[_web_view goForward];
}

- (BOOL)canGoBack
{
	return [_web_view canGoBack];
}

- (void)goBack
{
	[_web_view goBack];
}

@end
