/*
 * D2iP
 * Copyright (C) SatisKia. All rights reserved.
 */

#import <AudioToolbox/AudioServices.h>

#import "_Vibrator.h"

static void vibrateComplete( SystemSoundID soundID, void* client )
{
	if( ((_Vibrator*)client)->_vibrate )
	{
		AudioServicesPlaySystemSound( kSystemSoundID_Vibrate );
	}
	else
	{
		AudioServicesRemoveSystemSoundCompletion( kSystemSoundID_Vibrate );
	}
}

@implementation _Vibrator

- (void)startVibrate
{
	_vibrate = YES;
	AudioServicesAddSystemSoundCompletion( kSystemSoundID_Vibrate, NULL, NULL, vibrateComplete, self );
	AudioServicesPlaySystemSound( kSystemSoundID_Vibrate );
}

- (void)stopVibrate
{
	_vibrate = NO;
}

- (void)vibrate
{
	AudioServicesPlaySystemSound( kSystemSoundID_Vibrate );
}

@end
