/*
 * D2iP
 * Copyright (C) SatisKia. All rights reserved.
 */

#import "_String.h"

@implementation _String

- (id)init
{
	self = [super init];
	if( self != nil )
	{
		_str = [[NSMutableString alloc] initWithString:@""];
	}
	return self;
}

- (void)dealloc
{
	[_str release];

	[super dealloc];
}

- (_String*)set:(NSString*)str
{
	[_str setString:str];
	return self;
}

- (_String*)set:(NSString*)str :(int)beginIndex :(int)endIndex
{
	[_str setString:[str substringWithRange:NSMakeRange( beginIndex, endIndex - beginIndex )]];
	return self;
}

- (_String*)setCStr:(char*)str
{
	NSString* tmp = [[NSString alloc] initWithUTF8String:str];
	[_str setString:tmp];
	[tmp release];
	return self;
}

- (_String*)setData:(NSData*)data :(NSStringEncoding)encoding
{
	NSString* tmp = [[NSString alloc] initWithData:data encoding:encoding];
	[_str setString:tmp];
	[tmp release];
	return self;
}

- (_String*)setInt:(int)val
{
	[_str setString:[NSString stringWithFormat:@"%d", val]];
	return self;
}

- (_String*)add:(NSString*)str
{
	[_str appendString:str];
	return self;
}

- (_String*)add:(NSString*)str :(int)beginIndex :(int)endIndex
{
	NSString* tmp = [str substringWithRange:NSMakeRange( beginIndex, endIndex - beginIndex )];
	[_str appendString:tmp];
	return self;
}

- (_String*)addCStr:(char*)str
{
	NSString* tmp = [[NSString alloc] initWithUTF8String:str];
	[_str appendString:tmp];
	[tmp release];
	return self;
}

- (_String*)addData:(NSData*)data :(NSStringEncoding)encoding
{
	NSString* tmp = [[NSString alloc] initWithData:data encoding:encoding];
	[_str appendString:tmp];
	[tmp release];
	return self;
}

- (_String*)addInt:(int)val
{
	[_str appendFormat:@"%d", val];
	return self;
}

- (int)length
{
	return [_str length];
}

- (BOOL)equals:(NSString*)str
{
	return [_str isEqualToString:str];
}

- (int)indexOf:(NSString*)str
{
	NSRange range = [_str rangeOfString:str];
	if( range.location == NSNotFound )
	{
		return -1;
	}
	return range.location;
}

- (BOOL)startsWith:(NSString*)str
{
	return [_str hasPrefix:str];
}

- (BOOL)endsWith:(NSString*)str
{
	return [_str hasSuffix:str];
}

- (int)parseInt
{
	return [_str intValue];
}

- (NSString*)str
{
	return _str;
}

- (char*)allocCStr
{
	char* ret = malloc( [_str length] + 1 );
	strcpy( ret, [_str UTF8String] );
	return ret;
}

- (NSData*)allocData:(NSStringEncoding)encoding
{
	NSMutableString* tmp = [[NSMutableString alloc] initWithString:_str];
	CFStringNormalize( (CFMutableStringRef)tmp, kCFStringNormalizationFormC );
	NSData* ret = [[tmp dataUsingEncoding:encoding] retain];
	[tmp release];
	return ret;
}

- (int)charAt:(int)index
{
	const char* tmp = [_str UTF8String];
	if( index >= strlen( tmp ) )
	{
		return '\0';
	}
	return tmp[index];
}

@end
