/*
 * D2iP
 * Copyright (C) SatisKia. All rights reserved.
 */

#import "_Sound.h"

@implementation _Sound

- (id)init
{
	self = [super init];
	if( self != nil )
	{
		_player = nil;
		_volume = 1.0f;
	}
	return self;
}

- (void)dealloc
{
	if( _player != nil )
	{
		[_player stop];
		[_player release];
	}

	[super dealloc];
}

- (void)load:(NSURL*)url
{
	if( url != nil )
	{
		_player = [[AVAudioPlayer alloc] initWithContentsOfURL:url error:nil];
		if( _player != nil )
		{
			[_player prepareToPlay];
		}
	}
}

- (void)play:(BOOL)loop
{
	if( _player != nil )
	{
//		if( _player.playing )
//		{
//			[_player pause];
			_player.currentTime = 0.0f;
//		}
		if( loop )
		{
			_player.numberOfLoops = -1;
		}
		else
		{
			_player.numberOfLoops = 0;
		}
		_player.volume = _volume;
		[_player play];
	}
}

- (void)stop
{
	if( _player != nil )
	{
		if( _player.playing )
		{
			[_player pause];
			_player.currentTime = 0.0f;
		}
	}
}

- (void)setVolume:(int)volume
{
	_volume = (float)volume / 100.0f;
	if( _player != nil )
	{
		_player.volume = _volume;
	}
}

- (int)volume
{
	return (int)(_volume * 100.0f);
}

- (BOOL)isPlaying
{
	if( _player != nil )
	{
		return _player.playing;
	}
	return NO;
}

@end
