/*
 * D2iP
 * Copyright (C) SatisKia. All rights reserved.
 */

#import "_Music.h"

#import "_Main.h"

@implementation _Music

- (void)audioPlayerDidFinishPlaying:(AVAudioPlayer*)player successfully:(BOOL)flag
{
	[_m _musicComplete:self];
	if( [_m getCurrent] != nil )
	{
		[[_m getCurrent] _musicComplete:self];
	}
}

- (id)initWithMain:(_Main*)m
{
	self = [super init];
	if( self != nil )
	{
		_m = m;
		_player = nil;
		_volume = 1.0f;
	}
	return self;
}

- (void)dealloc
{
	[self stop];

	[super dealloc];
}

- (void)play:(NSURL*)url :(int)time :(BOOL)loop
{
	[self stop];
	if( url != nil )
	{
		_player = [[AVAudioPlayer alloc] initWithContentsOfURL:url error:nil];
		if( _player != nil )
		{
			_player.delegate = self;
			_player.currentTime = (float)time / 1000.0f;
			if( loop )
			{
				_player.numberOfLoops = -1;
			}
			else
			{
				_player.numberOfLoops = 0;
			}
			_player.volume = _volume;
			[_player prepareToPlay];
			[_player play];
		}
	}
}

- (void)stop
{
	if( _player != nil )
	{
		[_player stop];
		[_player release];
		_player = nil;
	}
}

- (void)setVolume:(int)volume
{
	_volume = (float)volume / 100.0f;
	if( _player != nil )
	{
		_player.volume = _volume;
	}
}

- (int)volume
{
	return (int)(_volume * 100.0f);
}

- (BOOL)isPlaying
{
	if( _player != nil )
	{
		return _player.playing;
	}
	return NO;
}

- (void)setCurrentTime:(int)time
{
	if( _player != nil )
	{
		[_player pause];
		_player.currentTime = (float)time / 1000.0f;
		[_player play];
	}
}

- (int)getCurrentTime
{
	if( _player != nil )
	{
		return (int)(_player.currentTime * 1000.0f);
	}
	return 0;
}

- (int)getTotalTime
{
	if( _player != nil )
	{
		return (int)(_player.duration * 1000.0f);
	}
	return 0;
}

@end
