/*
 * D2iP
 * Copyright (C) SatisKia. All rights reserved.
 */

#import "_Main.h"

#import "_Canvas.h"

@interface _MainViewController : UIViewController
{
@private
	_Main* _m;
}

- (id)initWithMain:(_Main*)m;

@end

@implementation _MainViewController

- (id)initWithMain:(_Main*)m
{
	self = [super init];
	if( self != nil )
	{
		_m = m;
	}
	return self;
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)orientation
{
	if( [_m _orientation] == ORIENTATION_LANDSCAPE )
	{
		return ((orientation == UIInterfaceOrientationLandscapeLeft/*ホームボタン左*/) ||
			(orientation == UIInterfaceOrientationLandscapeRight/*ホームボタン右*/));
	}
	else if( [_m _orientation] == ORIENTATION_PORTRAIT )
	{
		return ((orientation == UIInterfaceOrientationPortrait/*ホームボタン下*/) ||
			(orientation == UIInterfaceOrientationPortraitUpsideDown/*ホームボタン上*/));
	}
	return NO;
}

- (BOOL)shouldAutorotate
{
	return YES;
}
- (NSUInteger)supportedInterfaceOrientations
{
	if( [_m _orientation] == ORIENTATION_LANDSCAPE )
	{
		return ((1 << UIInterfaceOrientationLandscapeLeft/*ホームボタン左*/) |
			(1 << UIInterfaceOrientationLandscapeRight/*ホームボタン右*/));
	}
	else if( [_m _orientation] == ORIENTATION_PORTRAIT )
	{
		return ((1 << UIInterfaceOrientationPortrait/*ホームボタン下*/) |
			(1 << UIInterfaceOrientationPortraitUpsideDown/*ホームボタン上*/));
	}
	return 0;
}

- (void)willRotateToInterfaceOrientation:(UIInterfaceOrientation)toOrientation duration:(NSTimeInterval)duration
{
	[_m _onOrientationChange:toOrientation];
	if( [_m getCurrent] != nil )
	{
		[[_m getCurrent] _onOrientationChange:toOrientation];
	}
}

- (void)didRotateFromInterfaceOrientation:(UIInterfaceOrientation)fromOrientation
{
}

@end

@implementation _Main

- (BOOL)application:(UIApplication*)application handleOpenURL:(NSURL*)url
{
	if( _params != nil )
	{
		[_params release];
	}

	NSArray* params = [[url query] componentsSeparatedByString:@"&"];
	_params = [[NSMutableDictionary alloc] init];
	for( NSString* param in params )
	{
		NSArray* tmp = [param componentsSeparatedByString:@"="];
		if( ([tmp count] == 2) && ([(NSString*)[tmp objectAtIndex:0] length] > 0) )
		{
			[_params setObject:[(NSString*)[tmp objectAtIndex:1] stringByReplacingPercentEscapesUsingEncoding:NSUTF8StringEncoding] forKey:(NSString*)[tmp objectAtIndex:0]];
		}
	}

	return NO;
}

- (BOOL)application:(UIApplication*)application didFinishLaunchingWithOptions:(NSDictionary*)options
{
	if( [self _fullScreen] )
	{
		[[UIApplication sharedApplication] setStatusBarHidden:YES withAnimation:NO];
	}

	if( options != nil )
	{
		NSURL* url = [options objectForKey:UIApplicationLaunchOptionsURLKey];
		if( url != nil )
		{
			[self application:application handleOpenURL:url];
		}
	}

	_window = [[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] bounds]];
	_window.backgroundColor = [self _backgroundColor];
	[_window makeKeyAndVisible];

	_view_controller = [[_MainViewController alloc] initWithMain:self];
	if( [self _applyScale] )
	{
		_view_controller.view.contentScaleFactor = [UIScreen mainScreen].scale;
	}
	[_window addSubview:_view_controller.view];

	_canvas = nil;
	_view = nil;

	[self _start];

	return NO;
}

- (id)init
{
	self = [super init];
	if( self != nil )
	{
		_apply_scale = [self _applyScale];

		_params = nil;

		_active = YES;
	}
	return self;
}

- (void)dealloc
{
	[self _destroy];

	if( _params != nil )
	{
		[_params release];
	}

	[_window release];
	[_view_controller release];

	[super dealloc];
}

- (void)applicationWillResignActive:(UIApplication*)application
{
	if( _active )
	{
		_active = NO;

		[self _suspend];

		if( _canvas != nil )
		{
			[_canvas _suspend];

			[_canvas clearTouch];
		}
	}
}

- (void)applicationDidBecomeActive:(UIApplication*)application
{
	if( !_active )
	{
		[self _resume];

		if( _canvas != nil )
		{
			[_canvas _resume];
		}

		_active = YES;
	}
}

- (void)_setApplyScale:(BOOL)flag
{
	if( flag != _apply_scale )
	{
		_apply_scale = flag;

		if( _apply_scale )
		{
			_view_controller.view.contentScaleFactor = [UIScreen mainScreen].scale;
		}
		else
		{
			_view_controller.view.contentScaleFactor = 1.0f;
		}
	}
}

- (void)setApplyScale:(BOOL)flag
{
	if( _canvas != nil )
	{
		[_canvas _setApplyScale:flag];
	}
	else
	{
		[self _setApplyScale:flag];
	}
}

- (BOOL)applyScale
{
	return _apply_scale;
}

- (BOOL)_isActive
{
	return _active;
}

- (UIWindow*)getWindow
{
	return _window;
}

- (UIViewController*)getViewController
{
	return _view_controller;
}

- (UIInterfaceOrientation)getOrientation
{
	return [[UIApplication sharedApplication] statusBarOrientation];
}

- (void)setCurrent:(_Canvas*)canvas
{
	if( _view != nil )
	{
		return;
	}
	if( _canvas != nil )
	{
		[_canvas clearTouch];
		[_canvas _killTimer];
	}
	_canvas = canvas;
	_view_controller.view = _canvas;
	for( UIView* subview in _window.subviews )
	{
		[subview removeFromSuperview];
	}
	[_window setRootViewController:_view_controller];

	[_canvas _setApplyScale:_apply_scale];
	[_canvas _setTimer:self];
}

- (_Canvas*)getCurrent
{
	return _canvas;
}

- (void)setView:(UIView*)view
{
	if( _canvas != nil )
	{
		return;
	}
	_view = view;
	_view_controller.view = _view;
	[_window setRootViewController:_view_controller];
}

- (UIView*)getView
{
	return _view;
}

- (void)addCanvas:(_Canvas*)canvas
{
	if( _view == nil )
	{
		return;
	}
	if( _canvas != nil )
	{
		return;
	}
	_canvas = canvas;
	[_view addSubview:_canvas];
	[_canvas release];

	[_canvas _setApplyScale:_apply_scale];
	[_canvas _setTimer:self];
}

- (NSString*)getParameter:(NSString*)name
{
	if( _params != nil )
	{
		return [_params objectForKey:name];
	}
	return nil;
}
- (NSString*)getParameter:(NSString*)name defString:(NSString*)defString
{
	NSString* string = [self getParameter:name];
	if( string != nil )
	{
		return string;
	}
	return defString;
}
- (int)getParameter:(NSString*)name defInteger:(int)defInteger
{
	NSString* string = [self getParameter:name];
	if( string != nil )
	{
		return [string intValue];
	}
	return defInteger;
}

- (NSURL*)resourceURL:(NSString*)name
{
	NSString* path = [[NSBundle mainBundle] pathForResource:name ofType:@""];
	if( path != nil )
	{
		return [NSURL fileURLWithPath:path];
	}
	return nil;
}

- (BOOL)launch:(NSString*)name :(NSArray*)args
{
	NSMutableString* url = [[NSMutableString alloc] initWithString:name];
	[url appendString:@"://localhost/"];
	if( args != nil )
	{
		for( int i = 0; i < [args count] / 2; i++ )
		{
			if( i == 0 )
			{
				[url appendString:@"?"];
			}
			else
			{
				[url appendString:@"&"];
			}
			[url appendString:[args objectAtIndex:i * 2]];
			[url appendString:@"="];
			NSString* tmp = (NSString*)CFURLCreateStringByAddingPercentEscapes(
				kCFAllocatorDefault,
				(CFStringRef)[args objectAtIndex:i * 2 + 1],
				NULL,
				(CFStringRef)@"!*'();:@&=+$,/?%#[]",
				kCFStringEncodingUTF8
				);
			[url appendString:tmp];
			[tmp release];
		}
	}
	NSURL* url2 = [NSURL URLWithString:url];
	[url release];
	if( [[UIApplication sharedApplication] canOpenURL:url2] )
	{
		[[UIApplication sharedApplication] openURL:url2];
		return YES;
	}
	return NO;
}

- (void)openBrowser:(NSString*)url
{
	[[UIApplication sharedApplication] openURL:[NSURL URLWithString:url]];
}

- (NSString*)getUserAgentString
{
	UIWebView* webView = [[UIWebView alloc] initWithFrame:CGRectZero];
	NSString* string = [webView stringByEvaluatingJavaScriptFromString:@"navigator.userAgent"];
	[webView release];
	return string;
}

- (void)setUserAgentString:(NSString*)ua
{
	NSDictionary* dictionary = [NSDictionary dictionaryWithObject:ua forKey:@"UserAgent"];
	[[NSUserDefaults standardUserDefaults] registerDefaults:dictionary];
}

- (UIColor*)_backgroundColor { return [UIColor whiteColor]; }
- (int)_orientation { return ORIENTATION_NOSENSOR; }
- (BOOL)_fullScreen { return NO; }
- (BOOL)_applyScale { return NO; }

- (void)_start {}
- (void)_destroy {}
- (void)_suspend {}
- (void)_resume {}

- (void)_onOrientationChange:(UIInterfaceOrientation)orientation {}

- (void)_gameCenterAuthOK {}
- (void)_gameCenterAuthNG {}
- (void)_gameCenterReportAchievementOK:(NSString*)identifier :(float)percent {}
- (void)_gameCenterReportAchievementNG:(NSString*)identifier :(float)percent {}
- (void)_gameCenterCloseAchievementView {}
- (void)_gameCenterReportScoreOK:(NSString*)category :(int64_t)score {}
- (void)_gameCenterReportScoreNG:(NSString*)category :(int64_t)score {}
- (void)_gameCenterCloseLeaderboardView {}

- (void)_onHttpResponse:(NSData*)data {}
- (void)_onHttpError:(int)status {}

- (void)_inAppPurchaseInvalid:(NSString*)identifier {}
- (void)_inAppPurchasePurchaseOK:(NSString*)identifier :(NSData*)receipt {}
- (void)_inAppPurchasePurchaseNG:(NSString*)identifier {}
- (void)_inAppPurchaseRestoreOK:(NSString*)identifier {}
- (void)_inAppPurchaseRestoreNG {}
- (void)_inAppPurchaseRestoreCompleted {}
- (void)_inAppPurchaseCancelled:(NSString*)identifier {}

- (void)_musicComplete:(id)music {}

- (void)_twitterAuthOK {}
- (void)_twitterAuthNG {}
- (void)_twitterTweetOK {}
- (void)_twitterTweetNG:(int)status {}
- (void)_twitterCloseTweetComposeView {}

- (BOOL)_onWebViewShouldStartLoad:(NSString*)url { return NO; }
- (void)_onWebViewStartLoad:(NSString*)url {}
- (void)_onWebViewFinishLoad:(id)webView {}
- (void)_onWebViewLoadError:(NSError*)error :(id)webView {}

@end
