/*
 * D2iP
 * Copyright (C) SatisKia. All rights reserved.
 */

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

@interface _GLTexture : NSObject
{
@private
	int _num;
	unsigned int* _id;
	BOOL* _use_id;
	int* _index2id;
	int* _width;
	int* _height;
	BOOL* _alpha;
	BOOL* _depth;

	unsigned char** _t_rgba;
	unsigned char** _t_a;
	unsigned char* _t_trans;
	BOOL* _t_alpha;

	int _gen_num;
	BOOL _gen;

	int _canvas_height;

	// イメージ描画時の反転方法
	int _flipmode;
}

- (id)initWithNum:(int)index_num :(int)gen_num;
- (void)reset;
- (void)setDepth:(int)index :(BOOL)depth;
- (void)use:(int)index;
- (void)unuse:(int)index;
- (void)unuse;
- (void)setTransparency:(int)index :(unsigned char)trans;
- (int)id:(int)index;
- (int)width:(int)index;
- (int)height:(int)index;
- (BOOL)alpha:(int)index;
- (BOOL)depth:(int)index;
- (void)setCanvasHeight:(int)height;
- (void)setFlipMode:(int)flipmode;
- (void)draw:(int)index :(int)dx :(int)dy;
- (void)draw:(int)index :(int)dx :(int)dy :(int)sx :(int)sy :(int)swidth :(int)sheight;
- (void)draw:(int)index :(int)dx :(int)dy :(int)dwidth :(int)dheight :(int)sx :(int)sy :(int)swidth :(int)sheight;

- (NSString*)_resourceName:(int)index;
- (UIImage*)_allocImage:(int)index;
- (GLint)_filter:(int)index;
- (GLint)_wrap:(int)index;

@end
