/*
 * D2iP
 * Copyright (C) SatisKia. All rights reserved.
 */

#import <UIKit/UIKit.h>

#import "_Canvas.h"

#import "_Layout.h"
#import "_Main.h"

@implementation _Canvas

- (id)init
{
	CGRect frame = [[UIScreen mainScreen] applicationFrame];
	self = [super initWithFrame:frame];
	if( self != nil )
	{
		_apply_scale = NO;

		_timer = nil;

		_frame_width  = frame.size.width;
		_frame_height = frame.size.height;

		// レイアウト
		_layout = nil;

		// タッチイベント用
		self.multipleTouchEnabled = ([self _touchNum] > 1);
		_touch = [[NSMutableArray array] retain];

		_init_f = NO;
	}
	return self;
}

- (void)dealloc
{
	if( _timer != nil )
	{
		[_timer release];
	}

	if( _init_f )
	{
		[self _end];

		[_view release];

		[_g release];
	}

	[_touch release];

	[super dealloc];
}

- (void)_setApplyScale:(BOOL)flag
{
	if( flag != _apply_scale )
	{
		_apply_scale_f = YES;
	}
}

- (void)_setApplyScale
{
	if( _apply_scale_f )
	{
		_apply_scale = !_apply_scale;

		[_m _setApplyScale:_apply_scale];

		if( _init_f )
		{
			if( _apply_scale )
			{
				[_g _setScale:[UIScreen mainScreen].scale];
			}
			else
			{
				[_g _setScale:1.0f];
			}
		}

		_apply_scale_f = NO;
	}
}

- (BOOL)_applyScaleFlag
{
	return _apply_scale_f;
}

- (BOOL)_applyScale
{
	return _apply_scale;
}

- (BOOL)_initFlag
{
	return _init_f;
}

- (void)_setTimer:(_Main*)m
{
	_m = m;

	if( !_init_f )
	{
		if( [_m _orientation] == ORIENTATION_LANDSCAPE )
		{
			_width  = _frame_height;
			_height = _frame_width;
		}
		else
		{
			_width  = _frame_width;
			_height = _frame_height;
		}
		_size.width  = _width;
		_size.height = _height;

		_view = [[UIImageView alloc] initWithFrame:CGRectMake( 0, 0, _width, _height )];
		[self addSubview:_view];

		_g = [[_Graphics alloc] init];
		[_g _setCanvas:self];
		if( _apply_scale )
		{
			[_g _setScale:[UIScreen mainScreen].scale];
		}

		[self _init];

		_init_f = YES;
	}

	if( _timer == nil )
	{
		_timer = [[NSTimer
			scheduledTimerWithTimeInterval:(float)[self _frameTime] / 1000.0f
			target:self
			selector:@selector(_onTimer:)
			userInfo:nil
			repeats:YES
			] retain];
	}
}

- (void)_killTimer
{
	if( _timer != nil )
	{
		[_timer release];
		_timer = nil;
	}
}

- (void)_prePaint
{
	[self _setApplyScale];
}

- (void)_lock
{
	if( _apply_scale && (UIGraphicsBeginImageContextWithOptions != NULL) )
	{
		UIGraphicsBeginImageContextWithOptions( _size, NO, [UIScreen mainScreen].scale );
	}
	else
	{
		UIGraphicsBeginImageContext( _size );
	}
}

- (void)_unlock
{
	[_view setImage:UIGraphicsGetImageFromCurrentImageContext()];
	UIGraphicsEndImageContext();
}

- (void)_onTimer:(NSTimer*)timer
{
	if( [_m _isActive] )
	{
		[self _prePaint];

		[self _paint:_g];
	}
}

- (void)touchesBegan:(NSSet*)touches withEvent:(UIEvent*)event
{
	int i, j;
	NSArray* objects = [touches allObjects];
	int count = [objects count];
	for( i = 0; i < count; i++ )
	{
		if( [_touch count] < [self _touchNum] )
		{
			[_touch addObject:[objects objectAtIndex:i]];
			j = [_touch count] - 1;
			if( ![self _setLayoutEvent:LAYOUT_DOWN_EVENT :j] )
			{
				[self _processEvent:TOUCH_DOWN_EVENT :j];
			}
		}
	}
}
- (void)touchesMoved:(NSSet*)touches withEvent:(UIEvent*)event
{
	int i, j;
	NSArray* objects = [touches allObjects];
	int count = [objects count];
	NSObject* object;
	for( i = 0; i < count; i++ )
	{
		object = [objects objectAtIndex:i];
		for( j = [_touch count] - 1; j >= 0; j-- )
		{
			if( [object isEqual:[_touch objectAtIndex:j]] )
			{
				[self _processEvent:TOUCH_MOVE_EVENT :j];
			}
		}
	}
}
- (void)touchesEnded:(NSSet*)touches withEvent:(UIEvent*)event
{
	int i, j;
	NSArray* objects = [touches allObjects];
	int count = [objects count];
	NSObject* object;
	for( i = 0; i < count; i++ )
	{
		object = [objects objectAtIndex:i];
		for( j = [_touch count] - 1; j >= 0; j-- )
		{
			if( [object isEqual:[_touch objectAtIndex:j]] )
			{
				if( ![self _setLayoutEvent:LAYOUT_UP_EVENT :j] )
				{
					[self _processEvent:TOUCH_UP_EVENT :j];
				}
			}
		}
		for( j = [_touch count] - 1; j >= 0; j-- )
		{
			if( [object isEqual:[_touch objectAtIndex:j]] )
			{
				[_touch removeObjectAtIndex:j];
			}
		}
	}
}
- (void)touchesCancelled:(NSSet*)touches withEvent:(UIEvent*)event
{
	[self touchesEnded:touches withEvent:event];
}

- (_Main*)getMain
{
	return _m;
}

- (int)_getFrameWidth
{
	return _frame_width;
}
- (int)_getFrameHeight
{
	return _frame_height;
}

- (int)getWidth
{
	return _width;
}
- (int)getHeight
{
	return _height;
}

- (_Graphics*)getGraphics
{
	return _g;
}

- (void)clearTouch
{
	[_touch removeAllObjects];
}

- (int)getTouchNum
{
	return [_touch count];
}
- (int)getTouchX:(int)index
{
	CGPoint pos = [[_touch objectAtIndex:index] locationInView:self];
	return (int)(pos.x);
}
- (int)getTouchY:(int)index
{
	CGPoint pos = [[_touch objectAtIndex:index] locationInView:self];
	return (int)(pos.y);
}

- (void)setWindow:(int)left :(int)top :(int)right :(int)bottom :(int)width :(int)height
{
	_win_left   = left;
	_win_top    = top;
	_win_right  = right;
	_win_bottom = bottom;
	_win_width  = width;
	_win_height = height;
}
- (void)setWindow:(int)width :(int)height
{
	int w, h;
	if( (float)_height / (float)height < (float)_width / (float)width )
	{
		h = _height;
		w = (width * h) / height;
	}
	else
	{
		w = _width;
		h = (height * w) / width;
	}
	_win_left   = (_width  - w) / 2;
	_win_top    = (_height - h) / 2;
	_win_right  = _win_left + w;
	_win_bottom = _win_top  + h;
	_win_width  = width;
	_win_height = height;
}
- (int)getWindowLeft
{
	return _win_left;
}
- (int)getWindowTop
{
	return _win_top;
}
- (int)getWindowRight
{
	return _win_right;
}
- (int)getWindowBottom
{
	return _win_bottom;
}

- (int)windowX:(int)x
{
	return (x - _win_left) * _win_width / (_win_right - _win_left);
}
- (int)windowY:(int)y
{
	return (y - _win_top) * _win_height / (_win_bottom - _win_top);
}

- (int)screenX:(int)x
{
	return _win_left + x * (_win_right - _win_left) / _win_width;
}
- (int)screenY:(int)y
{
	return _win_top + y * (_win_bottom - _win_top) / _win_height;
}

- (void)setLayout:(_Layout*)layout
{
	_layout = layout;
}
- (BOOL)_setLayoutEvent:(int)type :(int)index
{
	if( _layout != nil )
	{
		int param = -1;
		if( [_layout _isWindow] )
		{
			param = [_layout _check:[self windowX:[self getTouchX:index]] :[self windowY:[self getTouchY:index]]];
		}
		else
		{
			param = [_layout _check:[self getTouchX:index] :[self getTouchY:index]];
		}
		if( param >= 0 )
		{
			[self _processEvent:type :param];
			return YES;
		}
	}
	return NO;
}
- (int)getLayoutState
{
	int ret = 0;
	if( _layout != nil )
	{
		for( int i = [self getTouchNum] - 1; i >= 0; i-- )
		{
			int id = -1;
			if( [_layout _isWindow] )
			{
				id = [_layout _check:[self windowX:[self getTouchX:i]] :[self windowY:[self getTouchY:i]]];
			}
			else
			{
				id = [_layout _check:[self getTouchX:i] :[self getTouchY:i]];
			}
			if( id >= 0 )
			{
				ret |= (1 << id);
			}
		}
	}
	return ret;
}

- (void)drawLayout:(_Graphics*)g
{
	if( _layout != nil )
	{
		[_layout _draw:self :g];
	}
}

- (void)addView:(UIView*)view :(int)tag
{
	view.tag = tag;
	[self addSubview:view];
	[view release];
}
- (void)removeView:(int)tag
{
	for( UIView* subview in self.subviews )
	{
		if( subview.tag == tag )
		{
			[subview removeFromSuperview];
			break;
		}
	}
}

- (int)_frameTime { return 16/*1000 / 60*/; }
- (int)_touchNum { return 2; }

- (void)_init {}
- (void)_end {}
- (void)_paint:(_Graphics*)g {}
- (void)_suspend {}
- (void)_resume {}
- (void)_processEvent:(int)type :(int)param {}

- (void)_onOrientationChange:(UIInterfaceOrientation)orientation {}

- (void)_gameCenterAuthOK {}
- (void)_gameCenterAuthNG {}
- (void)_gameCenterReportAchievementOK:(NSString*)identifier :(float)percent {}
- (void)_gameCenterReportAchievementNG:(NSString*)identifier :(float)percent {}
- (void)_gameCenterCloseAchievementView {}
- (void)_gameCenterReportScoreOK:(NSString*)category :(int64_t)score {}
- (void)_gameCenterReportScoreNG:(NSString*)category :(int64_t)score {}
- (void)_gameCenterCloseLeaderboardView {}

- (void)_onHttpResponse:(NSData*)data {}
- (void)_onHttpError:(int)status {}

- (void)_inAppPurchaseInvalid:(NSString*)identifier {}
- (void)_inAppPurchasePurchaseOK:(NSString*)identifier :(NSData*)receipt {}
- (void)_inAppPurchasePurchaseNG:(NSString*)identifier {}
- (void)_inAppPurchaseRestoreOK:(NSString*)identifier {}
- (void)_inAppPurchaseRestoreNG {}
- (void)_inAppPurchaseRestoreCompleted {}
- (void)_inAppPurchaseCancelled:(NSString*)identifier {}

- (void)_musicComplete:(id)music {}

- (void)_twitterAuthOK {}
- (void)_twitterAuthNG {}
- (void)_twitterTweetOK {}
- (void)_twitterTweetNG:(int)status {}
- (void)_twitterCloseTweetComposeView {}

- (BOOL)_onWebViewShouldStartLoad:(NSString*)url { return NO; }
- (void)_onWebViewStartLoad:(NSString*)url {}
- (void)_onWebViewFinishLoad:(id)webView {}
- (void)_onWebViewLoadError:(NSError*)error :(id)webView {}

@end
