#include "_Global.h"

class Main extends _Main
{
	var g:_Graphics;

	var load_text:_LoadText;
	var text:String;

	var step:Number;

	function start():Boolean
	{
		g = getGraphics();

		load_text = new _LoadText( this );
		text = null;

		step = -1;

		return true;
	}

	function paint():Void
	{
		g.lock();
		g.setFont( _FONT_TINY );
		g.setColor( g.getColorOfRGB( 0, 0, 255 ) );
		if( load_text.busy() )
		{
			g.drawString( "Loading...", 0, 12 );
		}
		else
		{
			if( text == null )
			{
				g.drawString( "null", 0, 12 );
			}
			else
			{
				var y = 12;
				var top = 0;
				var cur;
				for( cur = 0; cur < text.length; cur++ )
				{
					if( text.charCodeAt( cur ) == 0x0d )
					{
						g.drawString( text.substring( top, cur ), 0, y );
						y += 12;
						top = cur + 2;
						cur++;	// 0x0a を読み飛ばす
					}
					else if( text.charCodeAt( cur ) == 0x0a )
					{
						g.drawString( text.substring( top, cur ), 0, y );
						y += 12;
						top = cur + 1;
					}
				}
				if( top < cur )
				{
					g.drawString( text.substring( top, cur ), 0, y );
				}
			}
		}
		g.unlock();
	}

	function processEvent( type:Number, param:Number ):Void
	{
		if( type == _KEY_PRESSED_EVENT )
		{
			if( load_text.busy() ) return;
			step++;
			if( step > 3 )
			{
				step = 0;
			}
			load_text.load( "test" + step + ".txt" );
		}
	}

	function onLoadText( text:String ):Void
	{
		if( text == null )
		{
			this.text = null;
		}
		else
		{
			this.text = unescape( text );
		}
	}
}
