#include "_Global.h"

#include "Main.h"

class Main extends _Main
{
	var g;

	var mode;
	var state;

	var x, y;
	var dir;
	var step;

	var load_movie;

	var res;
	var clip;
	var loaded;

	function set_state( s )
	{
		state = s;
		switch( state )
		{
		case STATE_LOAD:
			x = 600;
			y = 600;
			dir = DIR_UP;
			step = 0;
			break;
		case STATE_PLAY:
			break;
		}
	}

	function start():Boolean
	{
		g = getGraphics();

		mode = Number( getParameter( "mode" ) );

		load_movie = new _LoadMovie( this );

		var i, j;
		clip   = new Array( 16 );
		loaded = new Array( 16 );
		for( i = 0; i < 16; i++ )
		{
			clip  [i] = new Array( 16 );
			loaded[i] = new Array( 16 );
			for( j = 0; j < 16; j++ )
			{
				clip  [i][j] = new _MovieClip();
				loaded[i][j] = false;
			}
		}

		set_state( STATE_LOAD );

		return true;
	}

	function drawMovie( ix, iy, x, y )
	{
		if( (ix >= 0) && (ix < 16) && (iy >= 0) && (iy < 16) )
		{
//			if( (x > -240) && (x < 240) && (y > -240) && (y < 240) )
//			{
				g.drawMovie( clip[iy][ix], x, y );
//			}
		}
	}

	function paint():Void
	{
		var key = getKeypadState();
		if( load_movie.busy() )
		{
			_key = 0;
			key = _key;
		}
		switch( state )
		{
		case STATE_LOAD:
			g.lock();
			g.setColor( g.getColorOfRGB( 0, 0, 0 ) );
			g.fillRect( 0, 0, 240, 240 );
			g.setColor( g.getColorOfRGB( 255, 255, 255 ) );
			g.setFont( _FONT_SMALL );
			g.drawString( "PRESS ANY KEY", 120 - _DIV( g.stringWidth( "PRESS ANY KEY" ), 2 ), 120 );
			g.drawString( "MODE " + mode, 0, 235 );
			g.unlock();
			break;
		case STATE_PLAY:
			if( !load_movie.busy() )
			{
				if( ((key & keyBit( _KEY_2 )) != 0) || ((key & keyBit( _KEY_UP )) != 0) )
				{
					y -= 12;
					dir = DIR_UP;
					step++;
				}
				else if( ((key & keyBit( _KEY_4 )) != 0) || ((key & keyBit( _KEY_LEFT )) != 0) )
				{
					x -= 12;
					dir = DIR_LEFT;
					step++;
				}
				else if( ((key & keyBit( _KEY_6 )) != 0) || ((key & keyBit( _KEY_RIGHT )) != 0) )
				{
					x += 12;
					dir = DIR_RIGHT;
					step++;
				}
				else if( ((key & keyBit( _KEY_8 )) != 0) || ((key & keyBit( _KEY_DOWN )) != 0) )
				{
					y += 12;
					dir = DIR_DOWN;
					step++;
				}
				else
				{
					step = 0;
				}
			}
			g.lock();
			if( load_movie.busy() )
			{
				g.setColor( g.getColorOfRGB( 0, 0, 0 ) );
				g.fillRect( 0, 0, 240, 240 );
				g.setColor( g.getColorOfRGB( 255, 255, 255 ) );
				g.setFont( _FONT_SMALL );
				g.drawString( "LOADING...", 0, 235 );
				g.unlock();
				break;
			}
			switch( mode )
			{
			case MODE_PAGE:
				if( _MOD( x, 240 ) == 12 )
				{
					x += 12;
					step--;
				}
				if( _MOD( y, 240 ) == 12 )
				{
					y += 12;
					step--;
				}
				if( _MOD( x, 240 ) == 228 )
				{
					x -= 12;
					step--;
				}
				if( _MOD( y, 240 ) == 228 )
				{
					y -= 12;
					step--;
				}
				g.drawMovie( clip[_DIV( y, 240 )][_DIV( x, 240 )], 0, 0 );
				switch( _MOD( step, 4 ) )
				{
				case 0:
					switch( dir )
					{
					case DIR_UP:
						g.drawImage( IMAGE_UP1, _MOD( x, 240 ) - 16, _MOD( y, 240 ) - 16 );
						break;
					case DIR_DOWN:
						g.setFlipMode( _FLIP_VERTICAL );
						g.drawImage( IMAGE_UP1, _MOD( x, 240 ) - 16, _MOD( y, 240 ) - 16 );
						g.setFlipMode( _FLIP_NONE );
						break;
					case DIR_LEFT:
						g.drawImage( IMAGE_LEFT1, _MOD( x, 240 ) - 16, _MOD( y, 240 ) - 16 );
						break;
					case DIR_RIGHT:
						g.setFlipMode( _FLIP_HORIZONTAL );
						g.drawImage( IMAGE_LEFT1, _MOD( x, 240 ) - 16, _MOD( y, 240 ) - 16 );
						g.setFlipMode( _FLIP_NONE );
						break;
					}
					break;
				case 1:
				case 3:
					switch( dir )
					{
					case DIR_UP:
						g.drawImage( IMAGE_UP2, _MOD( x, 240 ) - 16, _MOD( y, 240 ) - 16 );
						break;
					case DIR_DOWN:
						g.setFlipMode( _FLIP_VERTICAL );
						g.drawImage( IMAGE_UP2, _MOD( x, 240 ) - 16, _MOD( y, 240 ) - 16 );
						g.setFlipMode( _FLIP_NONE );
						break;
					case DIR_LEFT:
						g.drawImage( IMAGE_LEFT2, _MOD( x, 240 ) - 16, _MOD( y, 240 ) - 16 );
						break;
					case DIR_RIGHT:
						g.setFlipMode( _FLIP_HORIZONTAL );
						g.drawImage( IMAGE_LEFT2, _MOD( x, 240 ) - 16, _MOD( y, 240 ) - 16 );
						g.setFlipMode( _FLIP_NONE );
						break;
					}
					break;
				case 2:
					switch( dir )
					{
					case DIR_UP:
						g.drawImage( IMAGE_UP3, _MOD( x, 240 ) - 16, _MOD( y, 240 ) - 16 );
						break;
					case DIR_DOWN:
						g.setFlipMode( _FLIP_VERTICAL );
						g.drawImage( IMAGE_UP3, _MOD( x, 240 ) - 16, _MOD( y, 240 ) - 16 );
						g.setFlipMode( _FLIP_NONE );
						break;
					case DIR_LEFT:
						g.drawImage( IMAGE_LEFT3, _MOD( x, 240 ) - 16, _MOD( y, 240 ) - 16 );
						break;
					case DIR_RIGHT:
						g.setFlipMode( _FLIP_HORIZONTAL );
						g.drawImage( IMAGE_LEFT3, _MOD( x, 240 ) - 16, _MOD( y, 240 ) - 16 );
						g.setFlipMode( _FLIP_NONE );
						break;
					}
					break;
				}
				break;
			case MODE_SCROLL:
				if( x == 0 )
				{
					x = 12;
					step--;
				}
				if( y == 0 )
				{
					y = 12;
					step--;
				}
				if( x == 3840 )
				{
					x = 3828;
					step--;
				}
				if( y == 3840 )
				{
					y = 3828;
					step--;
				}
				{
					var xx = _DIV( x, 240 );
					var yy = _DIV( y, 240 );
					var mx = _MOD( x, 240 );
					var my = _MOD( y, 240 );
					drawMovie( xx - 1, yy - 1, 120 - mx - 240, 120 - my - 240 );
					drawMovie( xx    , yy - 1, 120 - mx      , 120 - my - 240 );
					drawMovie( xx + 1, yy - 1, 120 - mx + 240, 120 - my - 240 );
					drawMovie( xx - 1, yy    , 120 - mx - 240, 120 - my       );
					drawMovie( xx    , yy    , 120 - mx      , 120 - my       );
					drawMovie( xx + 1, yy    , 120 - mx + 240, 120 - my       );
					drawMovie( xx - 1, yy + 1, 120 - mx - 240, 120 - my + 240 );
					drawMovie( xx    , yy + 1, 120 - mx      , 120 - my + 240 );
					drawMovie( xx + 1, yy + 1, 120 - mx + 240, 120 - my + 240 );
				}
				switch( _MOD( step, 4 ) )
				{
				case 0:
					switch( dir )
					{
					case DIR_UP:
						g.drawImage( IMAGE_UP1, 120 - 16, 120 - 16 );
						break;
					case DIR_DOWN:
						g.setFlipMode( _FLIP_VERTICAL );
						g.drawImage( IMAGE_UP1, 120 - 16, 120 - 16 );
						g.setFlipMode( _FLIP_NONE );
						break;
					case DIR_LEFT:
						g.drawImage( IMAGE_LEFT1, 120 - 16, 120 - 16 );
						break;
					case DIR_RIGHT:
						g.setFlipMode( _FLIP_HORIZONTAL );
						g.drawImage( IMAGE_LEFT1, 120 - 16, 120 - 16 );
						g.setFlipMode( _FLIP_NONE );
						break;
					}
					break;
				case 1:
				case 3:
					switch( dir )
					{
					case DIR_UP:
						g.drawImage( IMAGE_UP2, 120 - 16, 120 - 16 );
						break;
					case DIR_DOWN:
						g.setFlipMode( _FLIP_VERTICAL );
						g.drawImage( IMAGE_UP2, 120 - 16, 120 - 16 );
						g.setFlipMode( _FLIP_NONE );
						break;
					case DIR_LEFT:
						g.drawImage( IMAGE_LEFT2, 120 - 16, 120 - 16 );
						break;
					case DIR_RIGHT:
						g.setFlipMode( _FLIP_HORIZONTAL );
						g.drawImage( IMAGE_LEFT2, 120 - 16, 120 - 16 );
						g.setFlipMode( _FLIP_NONE );
						break;
					}
					break;
				case 2:
					switch( dir )
					{
					case DIR_UP:
						g.drawImage( IMAGE_UP3, 120 - 16, 120 - 16 );
						break;
					case DIR_DOWN:
						g.setFlipMode( _FLIP_VERTICAL );
						g.drawImage( IMAGE_UP3, 120 - 16, 120 - 16 );
						g.setFlipMode( _FLIP_NONE );
						break;
					case DIR_LEFT:
						g.drawImage( IMAGE_LEFT3, 120 - 16, 120 - 16 );
						break;
					case DIR_RIGHT:
						g.setFlipMode( _FLIP_HORIZONTAL );
						g.drawImage( IMAGE_LEFT3, 120 - 16, 120 - 16 );
						g.setFlipMode( _FLIP_NONE );
						break;
					}
					break;
				}
				break;
			}
			g.unlock();
			break;
		}
	}

	function processEvent( type:Number, param:Number ):Void
	{
		if( load_movie.busy() ) return;
		switch( type )
		{
		case _KEY_PRESSED_EVENT:
			switch( state )
			{
			case STATE_LOAD:
				switch( mode )
				{
				case MODE_PAGE:
					{
						var xx = _DIV( x, 240 );
						var yy = _DIV( y, 240 );
						var zz = yy * 16 + xx;
						if( zz < 10 )
						{
							res = load_movie.load( zz, "data/00" + zz + ".swf" );
						}
						else if( zz < 100 )
						{
							res = load_movie.load( zz, "data/0" + zz + ".swf" );
						}
						else
						{
							res = load_movie.load( zz, "data/" + zz + ".swf" );
						}
					}
					break;
				case MODE_SCROLL:
					res = load_movie.load( 0, "data/map.swf" );
					break;
				}
				set_state( STATE_PLAY );
				break;
			case STATE_PLAY:
				switch( mode )
				{
				case MODE_PAGE:
					{
						var load:Boolean = false;
						switch( param )
						{
						case _KEY_2:
						case _KEY_UP:
							if( _MOD( y, 240 ) == 24 )
							{
								if( y > 24 )
								{
									y -= 48;
									dir = DIR_UP;
									step++;
									load = true;
								}
							}
							break;
						case _KEY_4:
						case _KEY_LEFT:
							if( _MOD( x, 240 ) == 24 )
							{
								if( x > 24 )
								{
									x -= 48;
									dir = DIR_LEFT;
									step++;
									load = true;
								}
							}
							break;
						case _KEY_6:
						case _KEY_RIGHT:
							if( _MOD( x, 240 ) == 216 )
							{
								if( x < 3816 )
								{
									x += 48;
									dir = DIR_RIGHT;
									step++;
									load = true;
								}
							}
							break;
						case _KEY_8:
						case _KEY_DOWN:
							if( _MOD( y, 240 ) == 216 )
							{
								if( y < 3816 )
								{
									y += 48;
									dir = DIR_DOWN;
									step++;
									load = true;
								}
							}
							break;
						}
						if( load )
						{
							var xx = _DIV( x, 240 );
							var yy = _DIV( y, 240 );
							if( !loaded[yy][xx] )
							{
								var zz = yy * 16 + xx;
								if( zz < 10 )
								{
									res = load_movie.load( zz, "data/00" + zz + ".swf" );
								}
								else if( zz < 100 )
								{
									res = load_movie.load( zz, "data/0" + zz + ".swf" );
								}
								else
								{
									res = load_movie.load( zz, "data/" + zz + ".swf" );
								}
							}
						}
					}
					break;
				}
				break;
			}
			break;
		case _KEY_RELEASED_EVENT:
			break;
		}
	}

	function onLoadMovieStart():Void
	{
	}
	function onLoadMovieError( errorCode:String, httpStatus:Number ):Void
	{
	}
	function onLoadMovieProgress( loadedBytes:Number, totalBytes:Number ):Void
	{
	}
	function onLoadMovieComplete( httpStatus:Number ):Void
	{
	}
	function onLoadMovieInit():Void
	{
		switch( mode )
		{
		case MODE_PAGE:
			{
				var xx = _DIV( x, 240 );
				var yy = _DIV( y, 240 );
				clip[yy][xx] = res;
				loaded[yy][xx] = true;
			}
			break;
		case MODE_SCROLL:
			{
				var i, j, k;
				for( i = 0; i < 16; i++ )
				{
					for( j = 0; j < 16; j++ )
					{
						k = i * 16 + j;
						clip[i][j].attach( res, "map" + k, "clip" + k );
					}
				}
			}
			break;
		}
	}
}
