#include "_Global.h"

#ifdef _USE_BITMAPDATA
#define USE_BITMAP
#endif // _USE_BITMAPDATA

class Main extends _Main
{
	var g:_Graphics;

#ifdef USE_BITMAP
	var bitmap:_BitmapData;
#endif // USE_BITMAP

	var angle:Number;

	function start():Boolean
	{
		g = getGraphics();

#ifdef USE_BITMAP
		bitmap = new _BitmapData( this, 0 );
#endif // USE_BITMAP

		angle = 0;

		return true;
	}

	function drawScaledImage( x:Number, y:Number, w:Number, h:Number ):Void
	{
#ifdef USE_BITMAP
		g.drawScaledBitmap( bitmap, x, y, w, h );
#else
		g.drawScaledImage( 0, x, y, w, h );
#endif // USE_BITMAP
	}

	function drawTransImage( x:Number, y:Number, cx:Number, cy:Number, r360:Number, z128x:Number, z128y:Number ):Void
	{
#ifdef USE_BITMAP
		g.drawTransBitmap( bitmap, x, y, cx, cy, r360, z128x, z128y );
#else
		g.drawTransImage( 0, x, y, cx, cy, r360, z128x, z128y );
#endif // USE_BITMAP
	}

	function paint():Void
	{
		g.lock();

		g.setColor( g.getColorOfRGB( 255, 255, 255 ) );
		g.fillRect( 0, 0, 240, 240 );

		g.setAlpha( 192 );

		g.setColor( g.getColorOfRGB( 255, 0, 0 ) );
		g.fillRect( 40, 40, 100, 100 );
		g.setColor( g.getColorOfRGB( 0, 255, 0 ) );
		g.fillRect( 80, 80, 100, 100 );
		g.setColor( g.getColorOfRGB( 0, 0, 255 ) );
		g.fillRect( 120, 120, 100, 100 );

		drawScaledImage( 0, 0, 50, 50 );
		g.setFlipMode( _FLIP_HORIZONTAL );
		drawScaledImage( 60, 0, 50, 50 );
		g.setFlipMode( _FLIP_VERTICAL );
		drawScaledImage( 120, 0, 50, 50 );
		g.setFlipMode( _FLIP_ROTATE );
		drawScaledImage( 180, 0, 50, 50 );
		g.setFlipMode( _FLIP_NONE );

		drawTransImage( 0, 80, 0, 240, 45, 25, 25 );
		g.setFlipMode( _FLIP_HORIZONTAL );
		drawTransImage( 60, 80, 0, 240, 45, 25, 25 );
		g.setFlipMode( _FLIP_VERTICAL );
		drawTransImage( 120, 80, 0, 240, 45, 25, 25 );
		g.setFlipMode( _FLIP_ROTATE );
		drawTransImage( 180, 80, 0, 240, 45, 25, 25 );
		g.setFlipMode( _FLIP_NONE );

		drawTransImage( 30, 140, 120, 120, angle, 25, 25 );
		drawTransImage( 90, 140, 120, 120, angle, -25, 25 );
		drawTransImage( 150, 140, 120, 120, angle, 25, -25 );
		drawTransImage( 210, 140, 120, 120, angle, -25, -25 );
		angle++;

		g.drawImage( 1, 20, 170 );
		g.setFlipMode( _FLIP_HORIZONTAL );
		g.drawImage( 1, 80, 170 );
		g.setFlipMode( _FLIP_VERTICAL );
		g.drawImage( 1, 140, 170 );
		g.setFlipMode( _FLIP_ROTATE );
		g.drawImage( 1, 200, 170 );
		g.setFlipMode( _FLIP_NONE );

		g.setAlpha( 255 );

		g.unlock();
	}

	function processEvent( type:Number, param:Number ):Void
	{
	}
}
