/*
 * D2F
 * Copyright (C) SatisKia. All rights reserved.
 */

#include "_Global.h"

class _Sound
{
	var _m:_Main;

	var _sound:Sound;
	var _ready:Boolean;

	function _Sound( m:_Main, id:Number )
	{
		var ref:Object = this;

		_m = m;

		_m.createEmptyMovieClip( _SOUND_NAME + id, _SOUND_DEPTH + id );
		_sound = new Sound( _m[_SOUND_NAME + id] );
		_sound.onLoad = function( success:Boolean ):Void
		{
			ref._ready = true;
		};

		_ready = false;
	}

	function attach( id:String ):Void
	{
		_sound.attachSound( id );
		_ready = true;
	}

	function load( url:String ):Void
	{
		_sound.loadSound( url );
	}

	function ready():Boolean
	{
		return _ready;
	}

	function play():Void
	{
		_sound.start();
	}

	function stop():Void
	{
		_sound.stop();
	}

	function setVolume( volume:Number ):Void
	{
		_sound.setVolume( volume );
	}
}
