/*
 * D2F
 * Copyright (C) SatisKia. All rights reserved.
 */

#include "_Global.h"

class _Input
{
	var _m:_Main;

	var _input:TextField;
	var _font:Number;
	var _col:Number;

	function _Input( m:_Main )
	{
		_m = m;

		// 色
		_col = 0x000000;
	}

	function create( id:Number, x:Number, y:Number, width:Number, height:Number, font:Number ):Void
	{
		var i:Number;

		_font = font;

		if( height <= 0 )
		{
			height = _m._g._font_h[_font] + 4/*テキストフィールドのふち取り*/;
		}

		_m.createTextField( _INPUT_NAME + id, _INPUT_DEPTH + id, x, y, width, height );
		_input = _m[_INPUT_NAME + id];
		_input.border     = true;
		_input.selectable = true;
		_input.type       = "input";

//		var ref:Object = this;
//		_input.onChanged = function( changedField:TextField ):Void
//		{
//			var save_color:Number = ref._m._g._format[ref._font].color;
//			ref._m._g._format[ref._font].color = ref._col;
//			ref._input.setTextFormat( ref._m._g._format[ref._font] );
//			ref._m._g._format[ref._font].color = save_color;
//		};
	}

	function setBackground( background:Boolean, col:Number ):Void
	{
		_input.background      = background;
		_input.backgroundColor = col;
	}

	function setBorder( border:Boolean, col:Number ):Void
	{
		_input.border      = border;
		_input.borderColor = col;
	}

	function setColor( col:Number ):Void
	{
		_col = col;
	}

	function setFocus():Void
	{
		Selection.setFocus( _input );
	}

	function setText( text:String ):Void
	{
		var save_color:Number = _m._g._format[_font].color;
		_m._g._format[_font].color = _col;
		_input.setNewTextFormat( _m._g._format[_font] );
		_m._g._format[_font].color = save_color;

		_input.text = text;
	}

	function getText():String
	{
		return _input.text;
	}

	function remove():Void
	{
		_input.removeTextField();
	}
}
