/*
 * D2F
 * Copyright (C) SatisKia. All rights reserved.
 */

#include "_Global.h"

class _Focus
{
	var _input1:TextField;
	var _input2:TextField;
	var _input3:TextField;
	var _old_focus:Number;
	var _new_focus:Number;

	var _check:Number;

	function _Focus( m:_Main )
	{
		var ref:Object = this;

		_old_focus = -1;
		_new_focus = -1;
		m.createTextField( _FOCUS1_NAME, _FOCUS1_DEPTH, 0, 0, 0, 0 );
		_input1 = m[_FOCUS1_NAME];
		_input1._focusrect = false;
		_input1.border     = false;
		_input1.selectable = true;
		_input1.type       = "input";
		m.createTextField( _FOCUS2_NAME, _FOCUS2_DEPTH, 0, 1, 0, 0 );
		_input2 = m[_FOCUS2_NAME];
		_input2._focusrect = false;
		_input2.border     = false;
		_input2.selectable = true;
		_input2.type       = "input";
		m.createTextField( _FOCUS3_NAME, _FOCUS3_DEPTH, 0, 2, 0, 0 );
		_input3 = m[_FOCUS3_NAME];
		_input3._focusrect = false;
		_input3.border     = false;
		_input3.selectable = true;
		_input3.type       = "input";
		_input1.onSetFocus = function( oldFocus:Object ):Void
		{
			ref._old_focus = ref._new_focus;
			ref.setFocus( 0 );
			ref.setCheck();
		};
		_input2.onSetFocus = function( oldFocus:Object ):Void
		{
			ref._old_focus = ref._new_focus;
			ref.setFocus( 1 );
			ref.setCheck();
		};
		_input3.onSetFocus = function( oldFocus:Object ):Void
		{
			ref._old_focus = ref._new_focus;
			ref.setFocus( 2 );
			ref.setCheck();
		};

		_check = 0;
	}

	function setFocus( new_focus:Number ):Void
	{
		_new_focus = new_focus;
		_input1._visible = (_new_focus == 0) ? false : true;
		_input2._visible = (_new_focus == 1) ? false : true;
		_input3._visible = (_new_focus == 2) ? false : true;
	}

	function setCheck()
	{
		if( _old_focus != _new_focus )
		{
			if( _old_focus == 0 )
			{
				if( _new_focus == 1 )
				{
					_check = 1;
				}
				else
				{
					_check = -1;
				}
			}
			else
			{
				if( _new_focus == 0 )
				{
					_check = 1;
				}
				else
				{
					_check = -1;
				}
			}
		}
	}

	function unuse():Void
	{
		_input1._visible = false;
		_input2._visible = false;
		_input3._visible = false;
	}

	function use():Void
	{
		setFocus( _new_focus );
	}

	function check():Number
	{
		var ret:Number = _check;
		_check = 0;
		return ret;
	}
}
