// systemDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "system.h"
#include "systemDlg.h"

#include <mmsystem.h>

#include "..\System.hpp"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

char g_progDir[MAX_PATH];

SystemData data;

JOYINFO g_joyInfo;	// WCXeBbN
int g_selectButton;
BOOL g_setButton = FALSE;
UINT g_timerID;

/////////////////////////////////////////////////////////////////////////////
// CSystemDlg _CAO

CSystemDlg::CSystemDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSystemDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSystemDlg)
		// : ̈ʒu ClassWizard ɂăȍǉ܂B
	//}}AFX_DATA_INIT
	// : LoadIcon  Win32  DestroyIcon ̃TuV[PXv܂B
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_hIconS = (HICON)::LoadImage(
		AfxGetApp()->m_hInstance,
		MAKEINTRESOURCE(IDR_MAINFRAME), IMAGE_ICON, 16, 16,
		LR_DEFAULTCOLOR
		);
}

void CSystemDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSystemDlg)
		// : ̏ꏊɂ ClassWizard ɂ DDX  DDV ̌Ăяoǉ܂B
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSystemDlg, CDialog)
	//{{AFX_MSG_MAP(CSystemDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_RADIO_FULL, OnRadioFull)
	ON_BN_CLICKED(IDC_RADIO_WINDOW, OnRadioWindow)
	ON_BN_CLICKED(IDC_RADIO_30FPS, OnRadio30fps)
	ON_BN_CLICKED(IDC_RADIO_60FPS, OnRadio60fps)
	ON_WM_HSCROLL()
	ON_WM_TIMER()
	ON_WM_DESTROY()
	ON_WM_QUERYENDSESSION()
	ON_EN_SETFOCUS(IDC_EDIT_BUTTON1, OnSetfocusEditButton1)
	ON_EN_SETFOCUS(IDC_EDIT_BUTTON2, OnSetfocusEditButton2)
	ON_EN_SETFOCUS(IDC_EDIT_BUTTON3, OnSetfocusEditButton3)
	ON_EN_SETFOCUS(IDC_EDIT_BUTTON4, OnSetfocusEditButton4)
	ON_BN_CLICKED(IDC_RADIO_BUTTON1, OnRadioButton1)
	ON_BN_CLICKED(IDC_RADIO_BUTTON2, OnRadioButton2)
	ON_BN_CLICKED(IDC_RADIO_BUTTON3, OnRadioButton3)
	ON_BN_CLICKED(IDC_RADIO_BUTTON4, OnRadioButton4)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSystemDlg bZ[W nh

BOOL CSystemDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CenterWindow(GetDesktopWindow());

	// ̃_CAOp̃ACRݒ肵܂Bt[[N̓AvP[ṼC
	// EBhE_CAOłȂ͎Iɐݒ肵܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACRݒ
	if ( ::GetSystemMetrics(SM_CYSMICON) < 32 ) {
		SetIcon(m_hIconS, FALSE);	// ACRݒ
	} else {
		SetIcon(m_hIcon, FALSE);	// ACRݒ
	}
	
	// TODO: ʂȏs͂̏ꏊɒǉĂB

	// vOfBNg̎擾
	char* ptrEnd;
	::GetModuleFileName(NULL, g_progDir, 128);
	if ( (ptrEnd = strrchr(g_progDir, '\\')) != NULL ) {
		*ptrEnd = '\0';
	} else {
		g_progDir[0] = '\0';
	}

	MySystem* sys = new MySystem(g_progDir);
	sys->load(&data);
	delete sys;

	if ( data.bWindow ) {
		((CButton*)GetDlgItem(IDC_RADIO_FULL  ))->SetCheck(0);
		((CButton*)GetDlgItem(IDC_RADIO_WINDOW))->SetCheck(1);
	} else {
		((CButton*)GetDlgItem(IDC_RADIO_FULL  ))->SetCheck(1);
		((CButton*)GetDlgItem(IDC_RADIO_WINDOW))->SetCheck(0);
	}

	if ( data.bFullFrame ) {
		((CButton*)GetDlgItem(IDC_RADIO_30FPS))->SetCheck(0);
		((CButton*)GetDlgItem(IDC_RADIO_60FPS))->SetCheck(1);
	} else {
		((CButton*)GetDlgItem(IDC_RADIO_30FPS))->SetCheck(1);
		((CButton*)GetDlgItem(IDC_RADIO_60FPS))->SetCheck(0);
	}

	if ( data.bShowFPS ) {
		((CButton*)GetDlgItem(IDC_CHECK_FPS))->SetCheck(1);
	} else {
		((CButton*)GetDlgItem(IDC_CHECK_FPS))->SetCheck(0);
	}

	if ( data.bWriteLog ) {
		((CButton*)GetDlgItem(IDC_CHECK_LOG))->SetCheck(1);
	} else {
		((CButton*)GetDlgItem(IDC_CHECK_LOG))->SetCheck(0);
	}

	CSliderCtrl* aSlider;
	char tmp[4];

	aSlider = (CSliderCtrl*)GetDlgItem(IDC_SLIDER_BGM);
	aSlider->SetRange   (0, 100);
	aSlider->SetLineSize(5);
	aSlider->SetPageSize(5);
	aSlider->SetTicFreq (5);
	aSlider->SetPos(data.volumeMusic);

	sprintf(tmp, "%d", data.volumeMusic);
	SetDlgItemText(IDC_STATIC_BGM, (LPCTSTR)tmp);

	aSlider = (CSliderCtrl*)GetDlgItem(IDC_SLIDER_SE);
	aSlider->SetRange   (0, 100);
	aSlider->SetLineSize(5);
	aSlider->SetPageSize(5);
	aSlider->SetTicFreq (5);
	aSlider->SetPos(data.volumeSound);

	sprintf(tmp, "%d", data.volumeSound);
	SetDlgItemText(IDC_STATIC_SE, (LPCTSTR)tmp);

	g_selectButton = 0;
	((CButton*)GetDlgItem(IDC_RADIO_BUTTON1))->SetCheck(1);
	((CButton*)GetDlgItem(IDC_RADIO_BUTTON2))->SetCheck(0);
	((CButton*)GetDlgItem(IDC_RADIO_BUTTON3))->SetCheck(0);
	((CButton*)GetDlgItem(IDC_RADIO_BUTTON4))->SetCheck(0);

	((CEdit*)GetDlgItem(IDC_EDIT_BUTTON1))->SetLimitText(1);
	((CEdit*)GetDlgItem(IDC_EDIT_BUTTON2))->SetLimitText(1);
	((CEdit*)GetDlgItem(IDC_EDIT_BUTTON3))->SetLimitText(1);
	((CEdit*)GetDlgItem(IDC_EDIT_BUTTON4))->SetLimitText(1);
	sprintf(tmp, "%d", (data.button[0] + 1));
	SetDlgItemText(IDC_EDIT_BUTTON1, (LPCTSTR)tmp);
	sprintf(tmp, "%d", (data.button[1] + 1));
	SetDlgItemText(IDC_EDIT_BUTTON2, (LPCTSTR)tmp);
	sprintf(tmp, "%d", (data.button[2] + 1));
	SetDlgItemText(IDC_EDIT_BUTTON3, (LPCTSTR)tmp);
	sprintf(tmp, "%d", (data.button[3] + 1));
	SetDlgItemText(IDC_EDIT_BUTTON4, (LPCTSTR)tmp);

	g_timerID = SetTimer('RSSY', 100, NULL);

	return TRUE;  // TRUE ԂƃRg[ɐݒ肵tH[JX͎܂B
}

// _CAO{bNXɍŏ{^ǉȂ΁AACR`悷
// R[hȉɋLqKv܂BMFC AvP[V document/view
// fgĂ̂ŁȀ̓t[[Nɂ莩Iɏ܂B

void CSystemDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `p̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// NCAg̋`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR`悵܂B
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// VXéA[U[ŏEBhEhbOĂԁA
// J[\\邽߂ɂĂяo܂B
HCURSOR CSystemDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CSystemDlg::OnOK() 
{
	// TODO: ̈ʒuɂ̑̌ؗp̃R[hǉĂ

	if ( ((CButton*)GetDlgItem(IDC_CHECK_FPS))->GetCheck() ) {
		data.bShowFPS = TRUE;
	} else {
		data.bShowFPS = FALSE;
	}

	if ( ((CButton*)GetDlgItem(IDC_CHECK_LOG))->GetCheck() ) {
		data.bWriteLog = TRUE;
	} else {
		data.bWriteLog = FALSE;
	}

	char tmp[16];
	GetDlgItemText(IDC_EDIT_BUTTON1, tmp, 15);
	data.button[0] = atol(tmp) - 1;
	GetDlgItemText(IDC_EDIT_BUTTON2, tmp, 15);
	data.button[1] = atol(tmp) - 1;
	GetDlgItemText(IDC_EDIT_BUTTON3, tmp, 15);
	data.button[2] = atol(tmp) - 1;
	GetDlgItemText(IDC_EDIT_BUTTON4, tmp, 15);
	data.button[3] = atol(tmp) - 1;

	MySystem* sys = new MySystem(g_progDir);
	sys->save(&data);
	delete sys;
	
	CDialog::OnOK();
}

void CSystemDlg::OnRadioFull() 
{
	data.bWindow = FALSE;
}

void CSystemDlg::OnRadioWindow() 
{
	data.bWindow = TRUE;
}

void CSystemDlg::OnRadio30fps() 
{
	data.bFullFrame = FALSE;
}

void CSystemDlg::OnRadio60fps() 
{
	data.bFullFrame = TRUE;
}

void CSystemDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	data.volumeMusic = ((CSliderCtrl*)GetDlgItem(IDC_SLIDER_BGM))->GetPos();
	data.volumeSound = ((CSliderCtrl*)GetDlgItem(IDC_SLIDER_SE ))->GetPos();

	char tmp[4];

	sprintf(tmp, "%d", data.volumeMusic);
	SetDlgItemText(IDC_STATIC_BGM, (LPCTSTR)tmp);

	sprintf(tmp, "%d", data.volumeSound);
	SetDlgItemText(IDC_STATIC_SE, (LPCTSTR)tmp);
	
	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CSystemDlg::OnTimer(UINT /*nIDEvent*/) 
{
	// WCXeBbN̓`FbN
	if ( !joyGetPos(JOYSTICKID1, &g_joyInfo) ) {
		if ( g_joyInfo.wButtons != 0 ) {
			if ( !g_setButton ) {
				int button = 0;
				if        ( g_joyInfo.wButtons & JOY_BUTTON1 ) {
					g_setButton = TRUE;
					button = 1;
				} else if ( g_joyInfo.wButtons & JOY_BUTTON2 ) {
					g_setButton = TRUE;
					button = 2;
				} else if ( g_joyInfo.wButtons & JOY_BUTTON3 ) {
					g_setButton = TRUE;
					button = 3;
				} else if ( g_joyInfo.wButtons & JOY_BUTTON4 ) {
					g_setButton = TRUE;
					button = 4;
				} else if ( g_joyInfo.wButtons & JOY_BUTTON5 ) {
					g_setButton = TRUE;
					button = 5;
				} else if ( g_joyInfo.wButtons & JOY_BUTTON6 ) {
					g_setButton = TRUE;
					button = 6;
				} else if ( g_joyInfo.wButtons & JOY_BUTTON7 ) {
					g_setButton = TRUE;
					button = 7;
				} else if ( g_joyInfo.wButtons & JOY_BUTTON8 ) {
					g_setButton = TRUE;
					button = 8;
				} else if ( g_joyInfo.wButtons & JOY_BUTTON9 ) {
					g_setButton = TRUE;
					button = 9;
				} else if ( g_joyInfo.wButtons & JOY_BUTTON10 ) {
					g_setButton = TRUE;
					button = 10;
				} else if ( g_joyInfo.wButtons & JOY_BUTTON11 ) {
					g_setButton = TRUE;
					button = 11;
				} else if ( g_joyInfo.wButtons & JOY_BUTTON12 ) {
					g_setButton = TRUE;
					button = 12;
				} else if ( g_joyInfo.wButtons & JOY_BUTTON13 ) {
					g_setButton = TRUE;
					button = 13;
				}
				if ( g_setButton ) {
					char tmp[8];
					sprintf(tmp, "%d", button);
					switch ( g_selectButton ) {
					case 0: SetDlgItemText(IDC_EDIT_BUTTON1, (LPCTSTR)tmp); break;
					case 1: SetDlgItemText(IDC_EDIT_BUTTON2, (LPCTSTR)tmp); break;
					case 2: SetDlgItemText(IDC_EDIT_BUTTON3, (LPCTSTR)tmp); break;
					case 3: SetDlgItemText(IDC_EDIT_BUTTON4, (LPCTSTR)tmp); break;
					}
				}
			}
		} else {
			if ( g_setButton ) {
				g_setButton = FALSE;
				g_selectButton++; if ( g_selectButton > 3 ) g_selectButton = 0;
				ChangeRadioButton();
			}
		}
	}
	
//	CDialog::OnTimer(nIDEvent);
}

void CSystemDlg::ChangeRadioButton()
{
	((CButton*)GetDlgItem(IDC_RADIO_BUTTON1))->SetCheck((g_selectButton == 0) ? 1 : 0);
	((CButton*)GetDlgItem(IDC_RADIO_BUTTON2))->SetCheck((g_selectButton == 1) ? 1 : 0);
	((CButton*)GetDlgItem(IDC_RADIO_BUTTON3))->SetCheck((g_selectButton == 2) ? 1 : 0);
	((CButton*)GetDlgItem(IDC_RADIO_BUTTON4))->SetCheck((g_selectButton == 3) ? 1 : 0);
}

void CSystemDlg::OnDestroy() 
{
	KillTimer(g_timerID);

	CDialog::OnDestroy();
}

BOOL CSystemDlg::OnQueryEndSession() 
{
	KillTimer(g_timerID);

	if (!CDialog::OnQueryEndSession())
		return FALSE;
	
	return TRUE;
}

void CSystemDlg::OnSetfocusEditButton1() 
{
	g_selectButton = 0;
	ChangeRadioButton();
}

void CSystemDlg::OnSetfocusEditButton2() 
{
	g_selectButton = 1;
	ChangeRadioButton();
}

void CSystemDlg::OnSetfocusEditButton3() 
{
	g_selectButton = 2;
	ChangeRadioButton();
}

void CSystemDlg::OnSetfocusEditButton4() 
{
	g_selectButton = 3;
	ChangeRadioButton();
}

void CSystemDlg::OnRadioButton1() 
{
	g_selectButton = 0;
}

void CSystemDlg::OnRadioButton2() 
{
	g_selectButton = 1;
}

void CSystemDlg::OnRadioButton3() 
{
	g_selectButton = 2;
}

void CSystemDlg::OnRadioButton4() 
{
	g_selectButton = 3;
}
