/****************************************************
 * ނ`                                       *
 * Copyright (C) SatisFactory. All rights reserved. *
 ****************************************************/

#include "_Global.h"

#include "_ImageInfo.hpp"

#include "Zanzou.hpp"

#define m g_main
#define g g_main->g

Zanzou::Zanzou(int id, int time) {
	_id = id;
	_info = new _ImageInfo(g->getImageInfo());
	_time = time;
	_alpha = _info->alpha;
	_elapse = 0;
}

Zanzou::~Zanzou() {
	delete _info;
}

BOOL Zanzou::update() {
	_elapse++;
	_info->alpha = _alpha - _alpha * _elapse / _time;
	if ( _info->alpha <= 0 ) {
		return FALSE;
	}
	return TRUE;
}

void Zanzou::draw() {
	g->drawImage(m->use_image(_id), _info);
}
