/****************************************************
 * ނ`                                       *
 * Copyright (C) SatisFactory. All rights reserved. *
 ****************************************************/

#include "_Global.h"

#include "JikiShot.hpp"

#define m g_main
#define g g_main->g

JikiShot::JikiShot(int type, int x, int y) {
	_type = type;
	switch ( _type ) {
	case JSHOT_NORMAL:
		_x0 = m->jiki->cx() - 12;
		_y0 = m->jiki->cy() - 12;
		_x1 = x - 12;
		_y1 = y - 12;
		_power = 1;
		break;
	case JSHOT_SPECIAL:
		_x0 = m->jiki->cx() - 24;
		_y0 = m->jiki->cy() - 24;
		_x1 = x - 24;
		_y1 = y - 24;
		_power = 2;
		break;
	case JSHOT_SWORD:
		_x0 = m->jiki->cx() - 40;
		_y0 = m->jiki->cy() - 40;
		_x1 = _x0;
		_y1 = _y0;
		_power = 1;
		break;
	}
	_x = _x0;
	_y = _y0;
	_color = m->jiki->_color;
	_elapse = 0;
}

int JikiShot::left() {
	switch ( _type ) {
	case JSHOT_NORMAL : return _x;
	case JSHOT_SPECIAL: return _x - 8;
	case JSHOT_SWORD  : return _x - 4;
	}
	return 0;
}

int JikiShot::top() {
	switch ( _type ) {
	case JSHOT_NORMAL : return _y;
	case JSHOT_SPECIAL: return _y - 8;
	case JSHOT_SWORD  : return _y - 4;
	}
	return 0;
}

int JikiShot::right() {
	switch ( _type ) {
	case JSHOT_NORMAL : return _x + 23;
	case JSHOT_SPECIAL: return _x + 55;
	case JSHOT_SWORD  : return _x + 83;
	}
	return 0;
}

int JikiShot::bottom() {
	switch ( _type ) {
	case JSHOT_NORMAL : return _y + 23;
	case JSHOT_SPECIAL: return _y + 55;
	case JSHOT_SWORD  : return _y + 83;
	}
	return 0;
}

int JikiShot::cx() {
	return (left() + right()) / 2;
}

int JikiShot::cy() {
	return (top() + bottom()) / 2;
}

BOOL JikiShot::update() {
	_elapse++;
	switch ( _type ) {
	case JSHOT_NORMAL:
		m->move(_x0, _y0, _x1, _y1, _elapse * 12);
		_x = m->move_x();
		_y = m->move_y();
		if ( (_x < -24) || (_x > 640) || (_y < -24) || (_y > 480) ) {
			return FALSE;
		}
		if ( _elapse == 1 ) {
			m->spark->addElement(new Spark(_x + 12, _y + 12, _color));
		}
		break;
	case JSHOT_SPECIAL:
		m->move(_x0, _y0, _x1, _y1, _elapse * 24);
		_x = m->move_x();
		_y = m->move_y();
		if ( (_x < -48) || (_x > 640) || (_y < -48) || (_y > 480) ) {
			return FALSE;
		}
		break;
	case JSHOT_SWORD:
		_x0 = m->jiki->cx() - 40;
		_y0 = m->jiki->cy() - 40;
		_x1 = _x0;
		_y1 = _y0;
		_x = _x0;
		_y = _y0;
		if ( _elapse >= 10 ) {
			return FALSE;
		}
		break;
	}
	return TRUE;
}

void JikiShot::draw() {
	switch ( _type ) {
	case JSHOT_NORMAL:
		g->setRot(0.5 * (double)_elapse);
		g->drawImage(m->use_image(DATA_SHOT), _x, _y, 24 * _color, 0, 24, 24);
		g->setRot(0.0);
		break;
	case JSHOT_SPECIAL:
		break;
	case JSHOT_SWORD:
		g->setAlpha(255 - 31 * (_elapse - 1));
		g->setRot(m->jiki->_r);
		if ( (m->jiki->_r > -1.5707963267949) && (m->jiki->_r < 1.5707963267949) ) {
			g->drawImage(m->use_image(DATA_SHOT), _x, _y, 80 * _color, 96, 80, 80);
		} else {
			g->drawImage(m->use_image(DATA_SHOT), _x, _y, 80 * _color, 176, 80, 80);
		}
		g->setRot(0.0);
		g->setAlpha(255);
		break;
	}
#ifdef SHOW_AREA
	m->drawArea(left(), top(), right() - left() + 1, bottom() - top() + 1);
#endif // SHOW_AREA
}
