/****************************************************
 * ނ`                                       *
 * Copyright (C) SatisFactory. All rights reserved. *
 ****************************************************/

#include "_Global.h"

#include "EnemyShot.hpp"

#define m g_main
#define g g_main->g

EnemyShot::EnemyShot(int type, int x0, int y0, int x1, int y1, int color, int speed) {
	_type = type;
	switch ( _type ) {
	case ESHOT_NORMAL:
		_x0 = x0 - 8;
		_y0 = y0 - 8;
		_x1 = x1 - 8;
		_y1 = y1 - 8;
		_color = 3;
		break;
	case ESHOT_SMALL:
		_x0 = x0 - 12;
		_y0 = y0 - 12;
		_x1 = x1 - 12;
		_y1 = y1 - 12;
		_color = color;
		break;
	case ESHOT_LARGE:
		_x0 = x0 - 24;
		_y0 = y0 - 24;
		_x1 = x1 - 24;
		_y1 = y1 - 24;
		_color = color;
		break;
	case ESHOT_BEAM:
		_x0 = x0 - 24;
		_y0 = y0 - 24;
		_color = color;
		break;
	}
	_x = _x0;
	_y = _y0;
	_speed = speed;
	_elapse = 0;
}

int EnemyShot::left() {
	switch ( _type ) {
	case ESHOT_NORMAL: return _x;
	case ESHOT_SMALL : return _x;
	case ESHOT_LARGE : return _x;
	case ESHOT_BEAM  : return _x;
	}
	return 0;
}

int EnemyShot::top() {
	switch ( _type ) {
	case ESHOT_NORMAL: return _y;
	case ESHOT_SMALL : return _y;
	case ESHOT_LARGE : return _y;
	case ESHOT_BEAM  : return _y;
	}
	return 0;
}

int EnemyShot::right() {
	switch ( _type ) {
	case ESHOT_NORMAL: return _x + 15;
	case ESHOT_SMALL : return _x + 23;
	case ESHOT_LARGE : return _x + 47;
	case ESHOT_BEAM  : return _x + 47;
	}
	return 0;
}

int EnemyShot::bottom() {
	switch ( _type ) {
	case ESHOT_NORMAL: return _y + 15;
	case ESHOT_SMALL : return _y + 23;
	case ESHOT_LARGE : return _y + 47;
	case ESHOT_BEAM  : return _y + 47;
	}
	return 0;
}

int EnemyShot::cx() {
	return (left() + right()) / 2;
}

int EnemyShot::cy() {
	return (top() + bottom()) / 2;
}

BOOL EnemyShot::update() {
	_elapse++;
	if ( _type == ESHOT_BEAM ) {
		if ( _elapse > 1 ) {
			return FALSE;
		}
	} else {
		m->move(_x0, _y0, _x1, _y1, _elapse * _speed);
		_x = m->move_x();
		_y = m->move_y();
		switch ( _type ) {
		case ESHOT_NORMAL:
			if ( (_x < -56) || (_x > 680) || (_y < -56) || (_y > 520) ) {
				return FALSE;
			}
			break;
		case ESHOT_SMALL:
			if ( (_x < -64) || (_x > 680) || (_y < -64) || (_y > 520) ) {
				return FALSE;
			}
			break;
		case ESHOT_LARGE:
			if ( (_x < -88) || (_x > 680) || (_y < -88) || (_y > 520) ) {
				return FALSE;
			}
			break;
		}
	}
	return TRUE;
}

void EnemyShot::draw() {
	switch ( _type ) {
	case ESHOT_NORMAL:
		g->drawImage(m->use_image(DATA_SHOT), _x, _y, 72 + 16 * ((m->elapse() / 5) % 3), 72, 16, 16);
		break;
	case ESHOT_SMALL:
		g->drawImage(m->use_image(DATA_SHOT), _x, _y, 24 * _color, 72, 24, 24);
		break;
	case ESHOT_LARGE:
		g->drawImage(m->use_image(DATA_SHOT), _x, _y, 48 * _color, 24, 48, 48);
		break;
	case ESHOT_BEAM:
		break;
	}
#ifdef SHOW_AREA
	m->drawArea(left(), top(), right() - left() + 1, bottom() - top() + 1);
#endif // SHOW_AREA
}
