/****************************************************
 * ނ`                                       *
 * Copyright (C) SatisFactory. All rights reserved. *
 ****************************************************/

#include "_Global.h"

#include "Burst.hpp"

#define m g_main
#define g g_main->g

Burst::Burst(int x, int y, int lag) {
	_x = x - 60 + (m->_rand->nextInt() % 20);
	_y = y - 60 + (m->_rand->nextInt() % 20);
	_lag = lag;
	_elapse = -1;
}

BOOL Burst::update() {
	_elapse++;
	if ( _elapse == _lag ) {
m->play_sound(SE_BURST);
	}
	if ( ((_elapse - _lag) / 6) > 3 ) {
		return FALSE;
	}
	return TRUE;
}

void Burst::draw() {
	g->setROP(_ROP_ADD);
	g->drawImage(m->use_image(DATA_BAKU), _x, _y, 120 * ((_elapse - _lag) / 6), 0, 120, 120);
	g->setROP(_ROP_COPY);
}
