/*
 * D2DX
 * Copyright (C) SatisKia. All rights reserved.
 */

#ifndef _STRING_HPP
#define _STRING_HPP

#include <windows.h>

#include "_Object.hpp"

class _String : public _Object
{
private:
	char* _str;

public:
	_String( const char* str );
	_String( const char* str, int beginIndex, int endIndex );
	_String( _String* str );
	_String( int val );

	virtual ~_String();

	void set( const char* str );
	void set( const char* str, int beginIndex, int endIndex );
	void set( _String* str );
	void set( int val );

	void add( const char* str );
	void add( const char* str, int beginIndex, int endIndex );
	void add( _String* str );
	void add( int val );

	int length();

	BOOL equals( const char* str );
	BOOL equals( _String* str );

	int parseInt();

	inline char* str(){ return _str; }
};

#endif // _STRING_HPP
