/*
 * D2DX
 * Copyright (C) SatisKia. All rights reserved.
 */

#include <windows.h>

#include "_SoundData.hpp"

#include "_Memory.hpp"

#ifdef _USE_DIRECTMUSIC
extern IDirectMusicPerformance8* g_pPerformance;
#endif // _USE_DIRECTMUSIC

_SoundData::_SoundData()
{
	sound = NULL;
	data = NULL;
}

_SoundData::~_SoundData()
{
	dispose();
}

#ifdef _USE_DIRECTMUSIC
void _SoundData::attach( IDirectMusicSegment8* sound )
{
#else
void _SoundData::attach( IDirectSoundBuffer* sound )
{
#endif // _USE_DIRECTMUSIC
	this->sound = sound;
	data = NULL;
}

void _SoundData::dispose()
{
	if( sound != NULL )
	{
		if( data != NULL )
		{
#ifdef _USE_DIRECTMUSIC
			sound->Unload( g_pPerformance );
#endif // _USE_DIRECTMUSIC
			sound->Release();
			delete data;
		}
		sound = NULL;
		data = NULL;
	}
}

BOOL _SoundData::isEnabled()
{
	return (sound != NULL) ? TRUE : FALSE;
}
