/*
 * D2DX
 * Copyright (C) SatisKia. All rights reserved.
 */

#include <windows.h>

#include <math.h>

#include <d3dx9.h>
#if D3D_SDK_VERSION >= 32
#include <dxerr.h>
#else
#include <dxerr9.h>
#endif // D3D_SDK_VERSION >= 32

#include "_Global.h"

#include "_Graphics.hpp"

#include "_Image.hpp"
#include "_ImageInfo.hpp"
#include "_Memory.hpp"
#include "_String.hpp"

#include "_Main.hpp"
#define WRITE_ERR(str,hr)	g_main->writeLog( str ); DXTRACE_ERR( str, hr )
#define RETURN_ERR(str,hr)	g_main->writeLog( str ); return DXTRACE_ERR( str, hr )

extern LPDIRECT3DDEVICE9 g_pD3DDevice;
extern LPD3DXSPRITE g_pD3DXSprite;
extern LPD3DXFONT g_pD3DXFont;
extern LPDIRECT3DTEXTURE9 g_pShapeTexture;
extern LPDIRECT3DSURFACE9 g_pShapeSurface;

_Graphics::_Graphics()
{
	_curCol = getColorOfRGB( 0, 0, 0 );

	_rop = _ROP_COPY;

	_scaleX = 1.0;
	_scaleY = 1.0;

	_rot = 0.0;

	_alpha = 255;

	_bright = 255;

	_flip = _FLIP_NONE;

	_lockDraw = FALSE;

	_imageInfo = new _ImageInfo();
}

_Graphics::~_Graphics()
{
	delete _imageInfo;
}

D3DCOLOR _Graphics::getColorOfRGB( int r255, int g255, int b255 )
{
	return D3DCOLOR_XRGB( r255, g255, b255 );
}

// ݐF
void _Graphics::setColor( D3DCOLOR col )
{
	_curCol = col;

	RECT tmp;
	tmp.left   = 0;
	tmp.top    = 0;
	tmp.right  = 1;
	tmp.bottom = 1;
	g_pD3DDevice->ColorFill( g_pShapeSurface, &tmp, _curCol );
}

// X^[Iy[V
void _Graphics::setROP( int rop )
{
	_rop = rop;
}
void _Graphics::SetROP()
{
	switch( _rop )
	{
	case _ROP_COPY:
		g_pD3DDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
		g_pD3DDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
		break;
	case _ROP_ADD:
		g_pD3DDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
		g_pD3DDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
		break;
	}
}

// g
void _Graphics::setScale( FLOAT scaleX, FLOAT scaleY )
{
	_scaleX = scaleX;
	_scaleY = scaleY;
}
void _Graphics::setScale( FLOAT scale )
{
	_scaleX = scale;
	_scaleY = scale;
}

// ]
void _Graphics::setRot( FLOAT rot )
{
	_rot = rot;
}

// tbv
void _Graphics::setFlipMode( int flip )
{
	_flip = flip;
}

// x
void _Graphics::setAlpha( int a255 )
{
	_alpha = a255;
}

// x
void _Graphics::setBright( int bright255 )
{
	_bright = bright255;
}

extern BOOL g_bDraw;
void _Graphics::lockDraw()
{
	if( !g_bDraw ) return;
	_lockDraw = TRUE;
	g_pD3DXSprite->Begin( D3DXSPRITE_ALPHABLEND | D3DXSPRITE_SORT_TEXTURE );
	SetROP();	// Begin ̌ɁI
}
void _Graphics::unlockDraw()
{
	if( !g_bDraw ) return;
	_lockDraw = FALSE;
	g_pD3DXSprite->Flush();
	g_pD3DXSprite->End();
}

/*
 * VFCv`
 */
void _Graphics::drawLine( int x0, int y0, int x1, int y1 )
{
	FLOAT scaleX = _scaleX;
	FLOAT scaleY = _scaleY;
	FLOAT rot = _rot;
	int flip = _flip;
	setScale( 1.0 );
	setRot( atan2( (double)(y1 - y0), (double)(x1 - x0) ) );
	setFlipMode( _FLIP_NONE );
	drawImage( g_pShapeTexture, x0, y0, 0, 0, (int)sqrt( (double)((y1 - y0) * (y1 - y0) + (x1 - x0) * (x1 - x0)) ), 2, 0, 0 );
	setScale( scaleX, scaleY );
	setRot( rot );
	setFlipMode( flip );
}
void _Graphics::drawRect( int x, int y, int w, int h )
{
	FLOAT scaleX = _scaleX;
	FLOAT scaleY = _scaleY;
	FLOAT rot = _rot;
	int flip = _flip;
	setScale( 1.0 );
	setRot( 0.0 );
	setFlipMode( _FLIP_NONE );
	drawImage( g_pShapeTexture, x    , y    , 0, 0, w + 1, 1 );
	drawImage( g_pShapeTexture, x    , y + 1, 0, 0, 1    , h );
	drawImage( g_pShapeTexture, x + w, y + 1, 0, 0, 1    , h );
	drawImage( g_pShapeTexture, x + 1, y + h, 0, 0, w - 1, 1 );
	setScale( scaleX, scaleY );
	setRot( rot );
	setFlipMode( flip );
}
void _Graphics::fillRect( int x, int y, int w, int h )
{
	FLOAT scaleX = _scaleX;
	FLOAT scaleY = _scaleY;
	FLOAT rot = _rot;
	int flip = _flip;
	setScale( 1.0 );
	setRot( 0.0 );
	setFlipMode( _FLIP_NONE );
	drawImage( g_pShapeTexture, x, y, 0, 0, w, h );
	setScale( scaleX, scaleY );
	setRot( rot );
	setFlipMode( flip );
}

int _Graphics::stringWidth( char* str )
{
	RECT rect;
	rect.left   = 0;
	rect.top    = 0;
	rect.right  = 0;
	rect.bottom = 0;
	g_pD3DXFont->DrawText(
		NULL,
		str,
		-1/*NULL I[܂ŕ\*/,
		&rect,
		DT_LEFT | DT_NOCLIP | DT_CALCRECT,
		NULL
		);
	return rect.right;
}
int _Graphics::stringWidth( _String* str )
{
	return stringWidth( str->str() );
}
int _Graphics::fontHeight()
{
	return _FONT_HEIGHT;
}

/*
 * `
 */
void _Graphics::drawString( char* str, int x, int y )
{
	if( !g_bDraw ) return;
	y -= _FONT_HEIGHT;
	if( !_lockDraw )
	{
		g_pD3DXSprite->Begin( D3DXSPRITE_ALPHABLEND | D3DXSPRITE_SORT_TEXTURE );
		SetROP();	// Begin ̌ɁI
	}
	RECT rect;
	rect.left   = x;
	rect.top    = y;
	rect.right  = g_main->width();
	rect.bottom = g_main->height();
	g_pD3DXFont->DrawText(
		g_pD3DXSprite,
		str,
		-1/*NULL I[܂ŕ\*/,
		&rect,
		DT_LEFT | DT_NOCLIP,
		_curCol
		);
	if( !_lockDraw )
	{
		g_pD3DXSprite->Flush();
		g_pD3DXSprite->End();
	}
}
void _Graphics::drawString( _String* str, int x, int y )
{
	drawString( str->str(), x, y );
}
void _Graphics::centerDrawString( char* str, int cx, int y )
{
	if( !g_bDraw ) return;
	y -= _FONT_HEIGHT;
	if( !_lockDraw )
	{
		g_pD3DXSprite->Begin( D3DXSPRITE_ALPHABLEND | D3DXSPRITE_SORT_TEXTURE );
		SetROP();	// Begin ̌ɁI
	}
	RECT rect;
	rect.left   = 0;
	rect.top    = y;
	rect.right  = cx * 2;
	rect.bottom = g_main->height();
	g_pD3DXFont->DrawText(
		g_pD3DXSprite,
		str,
		-1/*NULL I[܂ŕ\*/,
		&rect,
		DT_CENTER | DT_NOCLIP,
		_curCol
		);
	if( !_lockDraw )
	{
		g_pD3DXSprite->Flush();
		g_pD3DXSprite->End();
	}
}
void _Graphics::centerDrawString( _String* str, int cx, int y )
{
	centerDrawString( str->str(), cx, y );
}
void _Graphics::centerDrawString( char* str, int y )
{
	centerDrawString( str, g_main->width() / 2, y );
}
void _Graphics::centerDrawString( _String* str, int y )
{
	centerDrawString( str->str(), g_main->width() / 2, y );
}
void _Graphics::rightDrawString( char* str, int w, int y )
{
	if( !g_bDraw ) return;
	y -= _FONT_HEIGHT;
	if( !_lockDraw )
	{
		g_pD3DXSprite->Begin( D3DXSPRITE_ALPHABLEND | D3DXSPRITE_SORT_TEXTURE );
		SetROP();	// Begin ̌ɁI
	}
	RECT rect;
	rect.left   = 0;
	rect.top    = y;
	rect.right  = g_main->width() - w;
	rect.bottom = g_main->height();
	g_pD3DXFont->DrawText(
		g_pD3DXSprite,
		str,
		-1/*NULL I[܂ŕ\*/,
		&rect,
		DT_RIGHT | DT_NOCLIP,
		_curCol
		);
	if( !_lockDraw )
	{
		g_pD3DXSprite->Flush();
		g_pD3DXSprite->End();
	}
}
void _Graphics::rightDrawString( _String* str, int w, int y )
{
	rightDrawString( str->str(), w, y );
}
void _Graphics::rightDrawString( char* str, int y )
{
	rightDrawString( str, 0, y );
}
void _Graphics::rightDrawString( _String* str, int y )
{
	rightDrawString( str->str(), 0, y );
}

/*
 * C[W\z
 */
BOOL _Graphics::createImage( LPDIRECT3DTEXTURE9* image, _Memory* data )
{
	HRESULT hr = D3DXCreateTextureFromFileInMemory( g_pD3DDevice, data->ptr(), data->size(), image );
	if( FAILED( hr ) )
	{
		*image = NULL;
		WRITE_ERR( "C[W\zɎs", hr );
		return FALSE;
	}
	return TRUE;
}
BOOL _Graphics::createImage( LPDIRECT3DTEXTURE9* image, char* file )
{
	HRESULT hr = D3DXCreateTextureFromFile( g_pD3DDevice, file, image );
	if( FAILED( hr ) )
	{
		*image = NULL;
		WRITE_ERR( "C[W\zɎs", hr );
		return FALSE;
	}
	return TRUE;
}
BOOL _Graphics::createImage( _Image* image, _Memory* data )
{
	if( !createImage( &(image->image), data ) )
	{
		return FALSE;
	}
	D3DSURFACE_DESC desc;
	image->image->GetLevelDesc( 0, &desc );
	image->width  = desc.Width;
	image->height = desc.Height;
	return TRUE;
}
BOOL _Graphics::createImage( _Image* image, char* file )
{
	if( !createImage( &(image->image), file ) )
	{
		return FALSE;
	}
	D3DSURFACE_DESC desc;
	image->image->GetLevelDesc( 0, &desc );
	image->width  = desc.Width;
	image->height = desc.Height;
	return TRUE;
}

/*
 * C[Wj
 */
void _Graphics::disposeImage( LPDIRECT3DTEXTURE9 image )
{
	image->Release();
}
void _Graphics::disposeImage( _Image* image )
{
	image->dispose();
}

/*
 * C[W`
 */
void _Graphics::drawImage( LPDIRECT3DTEXTURE9 image, FLOAT x, FLOAT y )
{
	_imageInfo->rop    = _rop;
	_imageInfo->scaleX = 1.0;
	_imageInfo->scaleY = 1.0;
	_imageInfo->rot    = 0.0;
	_imageInfo->flip   = _FLIP_NONE;
	_imageInfo->alpha  = _alpha;
	_imageInfo->bright = _bright;
	_imageInfo->full   = TRUE;
	_imageInfo->dx     = x;
	_imageInfo->dy     = y;

	if( !g_bDraw || (image == NULL) ) return;

	D3DXVECTOR3 pos;
	pos.x = x;
	pos.y = y;
	pos.z = 0.0;

	if( !_lockDraw )
	{
		g_pD3DXSprite->Begin( D3DXSPRITE_ALPHABLEND | D3DXSPRITE_SORT_TEXTURE );
		SetROP();	// Begin ̌ɁI
	}
	g_pD3DXSprite->Draw( image, NULL, NULL, &pos, D3DCOLOR_RGBA( _bright, _bright, _bright, _alpha ) );
	if( !_lockDraw )
	{
		g_pD3DXSprite->Flush();
		g_pD3DXSprite->End();
	}
}
void _Graphics::drawImage( LPDIRECT3DTEXTURE9 image, FLOAT dx, FLOAT dy, int sx, int sy, int width, int height, FLOAT cx, FLOAT cy )
{
	_imageInfo->rop    = _rop;
	_imageInfo->scaleX = _scaleX;
	_imageInfo->scaleY = _scaleY;
	_imageInfo->rot    = _rot;
	_imageInfo->flip   = _flip;
	_imageInfo->alpha  = _alpha;
	_imageInfo->bright = _bright;
	_imageInfo->full   = FALSE;
	_imageInfo->dx     = dx;
	_imageInfo->dy     = dy;
	_imageInfo->sx     = sx;
	_imageInfo->sy     = sy;
	_imageInfo->width  = width;
	_imageInfo->height = height;
	_imageInfo->cx     = cx;
	_imageInfo->cy     = cy;

	if( !g_bDraw || (image == NULL) ) return;

	FLOAT scaleX = _scaleX;
	FLOAT scaleY = _scaleY;
	switch( _flip )
	{
	case _FLIP_HORIZONTAL:
		scaleX = 0.0 - scaleX;
		break;
	case _FLIP_VERTICAL:
		scaleY = 0.0 - scaleY;
		break;
	case _FLIP_ROTATE:
		scaleX = 0.0 - scaleX;
		scaleY = 0.0 - scaleY;
		break;
	}

	RECT rect;
	rect.left   = sx;
	rect.top    = sy;
	rect.right  = rect.left + width;
	rect.bottom = rect.top + height;

	D3DXVECTOR3 pos;

	if( !_lockDraw )
	{
		g_pD3DXSprite->Begin( D3DXSPRITE_ALPHABLEND | D3DXSPRITE_SORT_TEXTURE );
		SetROP();	// Begin ̌ɁI
	}
	if( (_rot == 0.0) && (scaleX == 1.0) && (scaleY == 1.0) )
	{
		pos.x = dx;
		pos.y = dy;
		pos.z = 0.0;

		g_pD3DXSprite->Draw( image, &rect, NULL, &pos, D3DCOLOR_RGBA( _bright, _bright, _bright, _alpha ) );
	}
	else
	{
		pos.x = 0.0;
		pos.y = 0.0;
		pos.z = 0.0;

		D3DXMATRIX mat;
		{
			D3DXMATRIX matS, matR, matT;
			D3DXMatrixScaling( &matS, scaleX, scaleY, 1.0 );
			D3DXMatrixRotationZ( &matR, _rot );
			D3DXMatrixTranslation( &matT, dx + cx, dy + cy, 0.0 );
			D3DXMatrixMultiply( &mat, &matS, &matR );	// ܂ Scaling  Rotation sA
			D3DXMatrixMultiply( &mat, &mat, &matT );	// Ō Translation 
		}
		g_pD3DXSprite->SetTransform( &mat );

		D3DXVECTOR3 center;
		center.x = cx;
		center.y = cy;
		center.z = 0.0;
		g_pD3DXSprite->Draw( image, &rect, &center, &pos, D3DCOLOR_RGBA( _bright, _bright, _bright, _alpha ) );

		D3DXMatrixIdentity( &mat );
		g_pD3DXSprite->SetTransform( &mat );
	}
	if( !_lockDraw )
	{
		g_pD3DXSprite->Flush();
		g_pD3DXSprite->End();
	}
}
void _Graphics::drawImage( LPDIRECT3DTEXTURE9 image, FLOAT dx, FLOAT dy, int sx, int sy, int width, int height )
{
	drawImage( image, dx, dy, sx, sy, width, height, (FLOAT)width / 2.0, (FLOAT)height / 2.0 );
}
void _Graphics::drawImage( LPDIRECT3DTEXTURE9 image, _ImageInfo* info )
{
	int rop = _rop;
	FLOAT scaleX = _scaleX;
	FLOAT scaleY = _scaleY;
	FLOAT rot = _rot;
	int flip = _flip;
	int alpha = _alpha;
	int bright = _bright;

	setROP( info->rop );
	setScale( info->scaleX, info->scaleY );
	setRot( info->rot );
	setFlipMode( info->flip );
	setAlpha( info->alpha );
	setBright( info->bright );

	if( info->full )
	{
		drawImage( image, info->dx, info->dy );
	}
	else
	{
		drawImage( image, info->dx, info->dy, info->sx, info->sy, info->width, info->height, info->cx, info->cy );
	}

	setBright( bright );
	setAlpha( alpha );
	setFlipMode( flip );
	setRot( rot );
	setScale( scaleX, scaleY );
	setROP( rop );
}
void _Graphics::drawScaledImage( LPDIRECT3DTEXTURE9 image, FLOAT dx, FLOAT dy, int width, int height, int sx, int sy, int swidth, int sheight )
{
	FLOAT scaleX = _scaleX;
	FLOAT scaleY = _scaleY;
	FLOAT rot = _rot;
	setScale( (FLOAT)width / (FLOAT)swidth, (FLOAT)height / (FLOAT)sheight );
	setRot( 0.0 );
	drawImage( image, dx, dy, sx, sy, swidth, sheight );
	setScale( scaleX, scaleY );
	setRot( rot );
}
void _Graphics::drawTransImage( LPDIRECT3DTEXTURE9 image, FLOAT dx, FLOAT dy, int sx, int sy, int width, int height, FLOAT cx, FLOAT cy, FLOAT r360, FLOAT z128x, FLOAT z128y )
{
	FLOAT scaleX = _scaleX;
	FLOAT scaleY = _scaleY;
	FLOAT rot = _rot;
	setScale( z128x / 128.0, z128y / 128.0 );
	setRot( r360 * 3.14159265358979323846264 / 180.0 );
	drawImage( image, dx - cx, dy - cy, sx, sy, width, height, cx, cy );
	setScale( scaleX, scaleY );
	setRot( rot );
}
void _Graphics::drawImage( _Image* image, FLOAT x, FLOAT y )
{
	drawImage( image->image, x, y, 0, 0, image->width, image->height );
}
void _Graphics::drawImage( _Image* image, FLOAT dx, FLOAT dy, int sx, int sy, int width, int height, FLOAT cx, FLOAT cy )
{
	drawImage( image->image, dx, dy, sx, sy, width, height, cx, cy );
}
void _Graphics::drawImage( _Image* image, FLOAT dx, FLOAT dy, int sx, int sy, int width, int height )
{
	drawImage( image->image, dx, dy, sx, sy, width, height );
}
void _Graphics::drawImage( _Image* image, _ImageInfo* info )
{
	drawImage( image->image, info );
}
void _Graphics::drawScaledImage( _Image* image, FLOAT dx, FLOAT dy, int width, int height, int sx, int sy, int swidth, int sheight )
{
	drawScaledImage( image->image, dx, dy, width, height, sx, sy, swidth, sheight );
}
void _Graphics::drawTransImage( _Image* image, FLOAT dx, FLOAT dy, int sx, int sy, int width, int height, FLOAT cx, FLOAT cy, FLOAT r360, FLOAT z128x, FLOAT z128y )
{
	drawTransImage( image->image, dx, dy, sx, sy, width, height, cx, cy, r360, z128x, z128y );
}

_ImageInfo* _Graphics::getImageInfo()
{
	return _imageInfo;
}
