#-------------------------------------------------------------------------------
# of_preRelease_v007_osx向けMakefile
#
# + of_preRelease_v007_osx.zipを展開する
# + MakefileのOF_PATHをof_preRelease_v007_osx.zip展開した場所
# + libs/fmodex/lib/osx/libfmodex.dylibは実行前に/usr/libとかへコピーしとく
#-------------------------------------------------------------------------------
CC            = gcc -arch i386 
CPP           = g++ -arch i386 
CFLAGS        = -g -Wall 
LDFLAGS       = -L/usr/local/lib 
LIBS          = -lm 
DEST          = /usr/local/bin
OBJS          = main.o testApp.o
PROGRAM       = run

# openframeworkの共通定義をインクルード
include ../Makefile-of.mk

# サフィックスルール適用対象の拡張子の定義
.SUFFIXES: .c .cpp .o

# サフィックスルール
.c.o:
	$(CC) $(CFLAGS) $(OF_CORE_HEADERS) -c $<

.cpp.o:
	$(CPP) $(CFLAGS) $(OF_CORE_HEADERS) -c $<

all:			$(PROGRAM)

$(PROGRAM):		$(OBJS)
				$(CPP) $(LDFLAGS) $(LIBS) $(OF_LINK) $(OBJS) -o $(PROGRAM)
				chmod 755 $(PROGRAM)

clean:;			rm -f *.o *~ $(PROGRAM)

install:		$(PROGRAM)
				install -s $(PROGRAM) $(DEST)
